/*
 * Decompiled with CFR 0.152.
 */
package rzk.wirelessredstone.screen;

import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import rzk.wirelessredstone.misc.WRUtils;

public abstract class FrequencyScreen
extends Screen {
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d*");
    private static final int WIDGET_WIDTH = 50;
    private static final int WIDGET_HEIGHT = 20;
    protected final int frequency;
    private EditBox frequencyInput;
    private Button done;
    private Button add1;
    private Button add10;
    private Button sub1;
    private Button sub10;

    protected FrequencyScreen(int frequency) {
        super((Component)Component.translatable((String)"gui.wirelessredstone.frequency.title"));
        this.frequency = frequency;
    }

    private Button addFrequencyButton(int x, int y, int value) {
        return (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.empty(), button -> {
            int frequency = 0;
            if (!this.frequencyInput.getValue().isBlank()) {
                frequency = this.getInputFrequency();
            }
            frequency += value * (FrequencyScreen.hasShiftDown() ? 100 : 1);
            frequency = WRUtils.clamp(0, 99999, frequency);
            this.frequencyInput.setValue(String.valueOf(frequency));
        }).pos(x, y).size(50, 20).build());
    }

    private void updateFrequencyButtonDesc() {
        if (FrequencyScreen.hasShiftDown()) {
            this.add1.setMessage((Component)Component.literal((String)"+100"));
            this.add10.setMessage((Component)Component.literal((String)"+1000"));
            this.sub1.setMessage((Component)Component.literal((String)"-100"));
            this.sub10.setMessage((Component)Component.literal((String)"-1000"));
        } else {
            this.add1.setMessage((Component)Component.literal((String)"+1"));
            this.add10.setMessage((Component)Component.literal((String)"+10"));
            this.sub1.setMessage((Component)Component.literal((String)"-1"));
            this.sub10.setMessage((Component)Component.literal((String)"-10"));
        }
    }

    protected void init() {
        this.frequencyInput = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, (this.width - 38) / 2, (this.height - 50) / 2, 38, 20, this.title));
        this.frequencyInput.setFilter(str -> DIGIT_PATTERN.matcher((CharSequence)str).matches());
        this.frequencyInput.setResponder(this::onFrequencyWritten);
        this.frequencyInput.setMaxLength(5);
        this.add1 = this.addFrequencyButton(this.frequencyInput.getX() + this.frequencyInput.getWidth() + 20, this.frequencyInput.getY() - 10 - 2, 1);
        this.add10 = this.addFrequencyButton(this.frequencyInput.getX() + this.frequencyInput.getWidth() + 20, this.frequencyInput.getY() + 10 + 2, 10);
        this.sub1 = this.addFrequencyButton(this.frequencyInput.getX() - 50 - 20, this.frequencyInput.getY() - 10 - 2, -1);
        this.sub10 = this.addFrequencyButton(this.frequencyInput.getX() - 50 - 20, this.frequencyInput.getY() + 10 + 2, -10);
        this.done = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            this.setFrequency();
            this.onClose();
        }).pos((this.width - 50) / 2, this.frequencyInput.getY() + 20 + 20).size(50, 20).build());
        this.done.active = false;
        if (WRUtils.isValidFrequency(this.frequency)) {
            this.frequencyInput.setValue(String.valueOf(this.frequency));
        }
        this.updateFrequencyButtonDesc();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 69) {
            this.onClose();
            return true;
        }
        if (keyCode == 257 && !this.frequencyInput.getValue().isBlank()) {
            this.setFrequency();
            this.onClose();
            return true;
        }
        if (keyCode == 340 || keyCode == 344) {
            this.updateFrequencyButtonDesc();
            return true;
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (super.keyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 340 || keyCode == 344) {
            this.updateFrequencyButtonDesc();
            return true;
        }
        return false;
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        context.drawString(this.font, this.title, (this.width - this.font.width((FormattedText)this.title)) / 2, this.frequencyInput.getY() - 30, 0xFFFFFF, false);
    }

    private void onFrequencyWritten(String str) {
        this.done.active = !str.isEmpty();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected int getInputFrequency() {
        return Integer.parseInt(this.frequencyInput.getValue());
    }

    protected abstract void setFrequency();
}

