/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.DetectedVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.data.UGAdvancements;
import quek.undergarden.data.UGBiomeTags;
import quek.undergarden.data.UGBlockStates;
import quek.undergarden.data.UGBlockTags;
import quek.undergarden.data.UGDamageTypeTags;
import quek.undergarden.data.UGDataMaps;
import quek.undergarden.data.UGEntityTags;
import quek.undergarden.data.UGFluidTags;
import quek.undergarden.data.UGItemModels;
import quek.undergarden.data.UGItemTags;
import quek.undergarden.data.UGLang;
import quek.undergarden.data.UGLootTables;
import quek.undergarden.data.UGRecipes;
import quek.undergarden.data.UGRegistries;
import quek.undergarden.data.UGSoundDefinitions;
import quek.undergarden.data.UGStructureUpdater;
import quek.undergarden.event.UndergardenClientEvents;
import quek.undergarden.event.UndergardenCommonEvents;
import quek.undergarden.network.CreateCritParticlePacket;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCarvers;
import quek.undergarden.registry.UGCreativeModeTabs;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGFoliagePlacers;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPointOfInterests;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructureProcessors;
import quek.undergarden.registry.UGStructures;
import quek.undergarden.registry.UGTreeDecoratorTypes;
import quek.undergarden.registry.UGTrunkPlacerTypes;

@Mod(value="undergarden")
public class Undergarden {
    public static final String MODID = "undergarden";

    public Undergarden(IEventBus bus, Dist dist) {
        DeferredRegister[] registers;
        if (dist.isClient()) {
            UndergardenClientEvents.initClientEvents(bus);
        }
        UndergardenCommonEvents.initCommonEvents(bus);
        bus.addListener(this::gatherData);
        bus.addListener(this::registerPackets);
        for (DeferredRegister register : registers = new DeferredRegister[]{UGAttachments.ATTACHMENTS, UGBlockEntities.BLOCK_ENTITIES, UGBlocks.BLOCKS, UGCarvers.CARVERS, UGCreativeModeTabs.TABS, UGCriteria.CRITERIA, UGEffects.EFFECTS, UGEnchantments.ENCHANTMENTS, UGEntityTypes.ENTITIES, UGFeatures.FEATURES, UGFluids.FLUIDS, UGFluids.TYPES, UGFoliagePlacers.FOLIAGE_PLACERS, UGItems.ITEMS, UGParticleTypes.PARTICLES, UGPointOfInterests.POI, UGPotions.POTIONS, UGSoundEvents.SOUNDS, UGStructureProcessors.PROCESSORS, UGStructures.STRUCTURES, UGTreeDecoratorTypes.TREE_DECORATORS, UGTrunkPlacerTypes.TRUNK_PLACERS}) {
            register.register(bus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)UndergardenConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)UndergardenConfig.CLIENT_SPEC);
    }

    public void registerPackets(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.play(CreateCritParticlePacket.ID, CreateCritParticlePacket::new, payload -> payload.client(CreateCritParticlePacket::handle));
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new UGBlockStates(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new UGItemModels(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new UGLang(output));
        generator.addProvider(event.includeClient(), (DataProvider)new UGSoundDefinitions(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGRecipes(output));
        generator.addProvider(event.includeServer(), (DataProvider)new UGLootTables(output));
        UGBlockTags blockTags = new UGBlockTags(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new UGItemTags(output, provider, blockTags.contentsGetter(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGEntityTags(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGAdvancements(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGFluidTags(output, provider, helper));
        UGRegistries datapackProvider = new UGRegistries(output, provider);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new UGBiomeTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGDamageTypeTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGStructureUpdater("structures", output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGDataMaps(output, lookupProvider));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Undergarden resources"), DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA), Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))));
    }
}

