/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.common.IPlantable;
import net.neoforged.neoforge.common.PlantType;
import quek.undergarden.registry.UGBlocks;

public class DeepsoilFarmlandBlock
extends FarmBlock {
    public DeepsoilFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MOISTURE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return !this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) ? ((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState() : super.getStateForPlacement(context);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter getter, BlockPos pos, Direction direction, IPlantable plantable) {
        PlantType type = plantable.getPlantType(getter, pos.relative(direction));
        return type == PlantType.CROP || type == PlantType.PLAINS;
    }

    public static void turnToDeepsoil(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.setBlockAndUpdate(pos, DeepsoilFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos));
        level.gameEvent(GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)state));
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.getFluidState(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private static boolean isUnderCrops(BlockGetter level, BlockPos pos) {
        BlockState plant = level.getBlockState(pos.above());
        BlockState state = level.getBlockState(pos);
        return plant.getBlock() instanceof IPlantable && state.canSustainPlant(level, pos, Direction.UP, (IPlantable)plant.getBlock());
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            DeepsoilFarmlandBlock.turnToDeepsoil(null, state, (Level)level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moistness = (Integer)state.getValue((Property)MOISTURE);
        if (!DeepsoilFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (moistness > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moistness - 1)), 2);
            } else if (!DeepsoilFarmlandBlock.isUnderCrops((BlockGetter)level, pos)) {
                DeepsoilFarmlandBlock.turnToDeepsoil(null, state, (Level)level, pos);
            }
        } else if (moistness < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDamage) {
        if (!level.isClientSide() && CommonHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)((Block)UGBlocks.DEEPSOIL.get()).defaultBlockState(), (float)fallDamage, (Entity)entity)) {
            DeepsoilFarmlandBlock.turnToDeepsoil(entity, state, level, pos);
        }
        entity.causeFallDamage(fallDamage, 1.0f, level.damageSources().fall());
    }
}

