/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import quek.undergarden.block.ShardTorchBlock;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGTags;

public class ShardWallTorchBlock
extends WallTorchBlock {
    public ShardWallTorchBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        Direction oppositeDirection = direction.getOpposite();
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x + 0.27 * (double)oppositeDirection.getStepX(), y + 0.22, z + 0.27 * (double)oppositeDirection.getStepZ(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)UGParticleTypes.SHARD.get(), x + 0.27 * (double)oppositeDirection.getStepX(), y + 0.22, z + 0.27 * (double)oppositeDirection.getStepZ(), 0.0, 0.0, 0.0);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(4.0), entity -> entity.getType().is(UGTags.Entities.ROTSPAWN)).forEach(entity -> {
            if (entity.hurt(UGDamageSources.getShardTorchDamage((Level)level, pos.getCenter()), 4.0f)) {
                ShardTorchBlock.drawParticlesTo(level, pos.getCenter(), (Entity)entity);
            }
        });
        level.scheduleTick(pos, (Block)this, 20);
    }
}

