/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class VirulentMixBlock
extends LiquidBlock {
    public VirulentMixBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties.noCollission().strength(100.0f).noLootTable().lightLevel(state -> 10));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.isAlive() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.getType().is(UGTags.Entities.IMMUNE_TO_VIRULENT_MIX) || livingEntity.hasEffect((MobEffect)UGEffects.VIRULENT_RESISTANCE.get())) {
                return;
            }
            livingEntity.addEffect(new MobEffectInstance((MobEffect)UGEffects.VIRULENCE.get(), 200, 0));
        }
    }

    public Optional<SoundEvent> getPickupSound() {
        return Optional.of((SoundEvent)UGSoundEvents.BUCKET_FILL_VIRULENT.get());
    }
}

