/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.animal.Scintling;

public class ScintlingModel<T extends Scintling>
extends AgeableListModel<T> {
    private final ModelPart head;
    private final ModelPart leftStalk;
    private final ModelPart rightStalk;
    private final ModelPart torso;
    private final ModelPart tail;

    public ScintlingModel(ModelPart root) {
        this.head = root.getChild("head");
        this.leftStalk = this.head.getChild("leftStalk");
        this.rightStalk = this.head.getChild("rightStalk");
        this.torso = root.getChild("torso");
        this.tail = root.getChild("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition tail = partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 18).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-3.0f, -1.0f, 5.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)6.0f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -5.0f, -7.0f, 8.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(26, 18).addBox(-3.0f, -2.0f, -6.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)-7.0f));
        PartDefinition leftStalk = head.addOrReplaceChild("leftStalk", CubeListBuilder.create().texOffs(20, 28).addBox(0.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-2.0f, (float)-5.0f, (float)0.3491f, (float)0.0f, (float)0.1745f));
        PartDefinition rightStalk = head.addOrReplaceChild("rightStalk", CubeListBuilder.create().texOffs(20, 28).mirror().addBox(-1.0f, -7.0f, -1.0f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-2.0f, (float)-5.0f, (float)0.3491f, (float)0.0f, (float)-0.1745f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float wiggle;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.torso.yRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * 0.5f * limbSwingAmount;
        this.tail.yRot = Mth.cos((float)(limbSwing * 0.5f)) * 0.5f * limbSwingAmount;
        this.leftStalk.xRot = wiggle = Mth.sin((float)((float)((Scintling)((Object)entity)).tickCount * 0.3f)) * 0.3f;
        this.rightStalk.xRot = -wiggle;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.head, (Object)this.torso, (Object)this.tail);
    }
}

