/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import quek.undergarden.block.entity.DepthrockBedBlockEntity;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.registry.UGBlockEntities;

public class DepthrockBedRender
implements BlockEntityRenderer<DepthrockBedBlockEntity> {
    private final ModelPart headPiece;
    private final ModelPart footPiece;

    public DepthrockBedRender(BlockEntityRendererProvider.Context context) {
        this.headPiece = context.bakeLayer(UGModelLayers.DEPTHROCK_BED_HEAD);
        this.footPiece = context.bakeLayer(UGModelLayers.DEPTHROCK_BED_FOOT);
    }

    public static LayerDefinition createHeadLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 9.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static LayerDefinition createFootLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        partDefinition.addOrReplaceChild("foot", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 9.0f), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void render(DepthrockBedBlockEntity bed, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        Level level = bed.getLevel();
        if (level != null) {
            BlockState blockstate = bed.getBlockState();
            DoubleBlockCombiner.NeighborCombineResult neighborCombineResult = DoubleBlockCombiner.combineWithNeigbour((BlockEntityType)((BlockEntityType)UGBlockEntities.DEPTHROCK_BED.get()), BedBlock::getBlockType, BedBlock::getConnectedDirection, (DirectionProperty)ChestBlock.FACING, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)bed.getBlockPos(), (levelAccessor, pos) -> false);
            int i = ((Int2IntFunction)neighborCombineResult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).get(light);
            this.renderPiece(stack, buffer, blockstate.getValue((Property)BedBlock.PART) == BedPart.HEAD ? this.headPiece : this.footPiece, (Direction)blockstate.getValue((Property)BedBlock.FACING), i, overlay, false);
        } else {
            this.renderPiece(stack, buffer, this.headPiece, Direction.SOUTH, light, overlay, false);
            this.renderPiece(stack, buffer, this.footPiece, Direction.SOUTH, light, overlay, true);
        }
    }

    private void renderPiece(PoseStack stack, MultiBufferSource multiBufferSource, ModelPart bedPart, Direction direction, int light, int overlay, boolean isBedFoot) {
        stack.pushPose();
        stack.translate(0.0, 0.5625, isBedFoot ? -1.0 : 0.0);
        stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        stack.translate(0.5, 0.5, 0.5);
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f + direction.toYRot()));
        stack.translate(-0.5, -0.5, -0.5);
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)new ResourceLocation("undergarden", "textures/block/depthrock_bed.png")));
        bedPart.render(stack, vertexConsumer, light, overlay);
        stack.popPose();
    }
}

