/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.Property;
import quek.undergarden.block.GrongletBlock;
import quek.undergarden.block.entity.GrongletBlockEntity;
import quek.undergarden.client.model.UGModelLayers;

public class GrongletRender
implements BlockEntityRenderer<GrongletBlockEntity> {
    private final ModelPart burs;
    private final ModelPart limbs;
    private final ModelPart body;

    public GrongletRender(BlockEntityRendererProvider.Context context) {
        ModelPart gronglet = context.bakeLayer(UGModelLayers.GRONGLET);
        this.burs = gronglet.getChild("burs");
        this.limbs = gronglet.getChild("limbs");
        this.body = gronglet.getChild("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition burs = partdefinition.addOrReplaceChild("burs", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)24.0f, (float)-6.0f));
        PartDefinition top_burs = burs.addOrReplaceChild("top_burs", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)6.0f));
        top_burs.addOrReplaceChild("lastbur", CubeListBuilder.create().texOffs(24, 22).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)4.0f));
        top_burs.addOrReplaceChild("middlebur", CubeListBuilder.create().texOffs(24, 20).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        top_burs.addOrReplaceChild("firstbur", CubeListBuilder.create().texOffs(24, 24).addBox(-4.0f, -2.0f, 0.0f, 8.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-4.0f));
        PartDefinition side_burs = burs.addOrReplaceChild("side_burs", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)-2.0f, (float)6.0f));
        side_burs.addOrReplaceChild("rightbur", CubeListBuilder.create().texOffs(8, 16).addBox(-2.0f, 0.0f, -6.0f, 2.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-0.0f, (float)0.0f));
        side_burs.addOrReplaceChild("leftbur", CubeListBuilder.create().texOffs(16, 0).addBox(0.0f, 0.0f, -6.0f, 2.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-0.0f, (float)0.0f));
        PartDefinition edge_burs = burs.addOrReplaceChild("edge_burs", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)0.0f, (float)6.0f));
        edge_burs.addOrReplaceChild("leftedgebur", CubeListBuilder.create().texOffs(4, 16).addBox(0.0f, 0.0f, -6.0f, 2.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        edge_burs.addOrReplaceChild("rightedgebur", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -6.0f, 2.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition limbs = partdefinition.addOrReplaceChild("limbs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)23.99f, (float)0.0f));
        limbs.addOrReplaceChild("legs", CubeListBuilder.create().texOffs(22, 16).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.0f, (float)6.0f));
        limbs.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(22, 18).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.0f, (float)-6.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -6.0f, 8.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(GrongletBlockEntity gronglet, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        Direction direction = (Direction)gronglet.getBlockState().getValue((Property)GrongletBlock.FACING);
        stack.pushPose();
        if (direction == Direction.UP) {
            stack.translate(0.5, 1.5, 0.5);
        }
        if (direction == Direction.DOWN) {
            stack.translate(0.5, -0.5, 0.5);
        }
        if (direction == Direction.SOUTH) {
            stack.translate(0.5, 0.5, 1.5);
        }
        if (direction == Direction.NORTH) {
            stack.translate(0.5, 0.5, -0.5);
        }
        if (direction == Direction.EAST) {
            stack.translate(1.5f, 0.5f, 0.5f);
        }
        if (direction == Direction.WEST) {
            stack.translate(-0.5f, 0.5f, 0.5f);
        }
        stack.mulPose(direction.getRotation());
        stack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        int yaw = gronglet.yaw;
        stack.mulPose(Axis.YP.rotationDegrees((float)yaw));
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)new ResourceLocation("undergarden", "textures/block/gronglet.png")));
        this.body.render(stack, consumer, light, overlay);
        this.limbs.render(stack, consumer, light, overlay);
        this.burs.render(stack, consumer, light, overlay);
        stack.popPose();
    }
}

