/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import quek.undergarden.client.model.ForgottenGuardianModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.layer.ForgottenGuardianEyesLayer;
import quek.undergarden.entity.boss.ForgottenGuardian;

public class ForgottenGuardianRender
extends MobRenderer<ForgottenGuardian, ForgottenGuardianModel<ForgottenGuardian>> {
    public ForgottenGuardianRender(EntityRendererProvider.Context context) {
        super(context, new ForgottenGuardianModel(context.bakeLayer(UGModelLayers.FORGOTTEN_GUARDIAN)), 0.6f);
        this.addLayer((RenderLayer)new ForgottenGuardianEyesLayer(this));
    }

    public ResourceLocation getTextureLocation(ForgottenGuardian entity) {
        return new ResourceLocation("undergarden", "textures/entity/forgotten_guardian.png");
    }

    public void setupRotations(ForgottenGuardian entity, PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.setupRotations((LivingEntity)entity, stack, ageInTicks, rotationYaw, partialTicks);
        if (!((double)entity.walkAnimation.speed() < 0.01)) {
            float f1 = entity.walkAnimation.position() - entity.walkAnimation.speed() * (1.0f - partialTicks) + 6.0f;
            float f2 = (Math.abs(f1 % 13.0f - 6.5f) - 3.25f) / 3.25f;
            stack.mulPose(Axis.ZP.rotationDegrees(6.5f * f2));
        }
    }
}

