/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.render.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;
import quek.undergarden.entity.UGBoat;

public class UGBoatRenderer
extends EntityRenderer<UGBoat> {
    private final Map<UGBoat.Type, Pair<ResourceLocation, BoatModel>> boatResources;

    public UGBoatRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context);
        this.shadowRadius = 0.8f;
        this.boatResources = (Map)Stream.of(UGBoat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("undergarden", UGBoatRenderer.getTextureLocation(type, chest)), (Object)this.createBoatModel(context, (UGBoat.Type)((Object)type), chest))));
    }

    private static ModelLayerLocation createLocation(String path, String model) {
        return new ModelLayerLocation(new ResourceLocation("undergarden", path), model);
    }

    public static ModelLayerLocation createBoatModelName(UGBoat.Type pType) {
        return UGBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(UGBoat.Type type) {
        return UGBoatRenderer.createLocation("chest_boat/" + type.getName(), "main");
    }

    private BoatModel createBoatModel(EntityRendererProvider.Context context, UGBoat.Type type, boolean chest) {
        ModelLayerLocation modellayerlocation = chest ? UGBoatRenderer.createChestBoatModelName(type) : UGBoatRenderer.createBoatModelName(type);
        ModelPart modelpart = context.bakeLayer(modellayerlocation);
        return chest ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    private static String getTextureLocation(UGBoat.Type type, boolean chest) {
        return chest ? "textures/entity/chest_boat/" + type.getName() + ".png" : "textures/entity/boat/" + type.getName() + ".png";
    }

    public void render(UGBoat entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        float bubbleAngle;
        stack.pushPose();
        stack.translate(0.0, 0.375, 0.0);
        stack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        float f = (float)entity.getHurtTime() - partialTicks;
        float f1 = entity.getDamage() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            stack.mulPose(Axis.XP.rotationDegrees(Mth.sin((float)f) * f * f1 / 10.0f * (float)entity.getHurtDir()));
        }
        if (!Mth.equal((float)(bubbleAngle = entity.getBubbleAngle(partialTicks)), (float)0.0f)) {
            stack.mulPose(new Quaternionf().setAngleAxis(entity.getBubbleAngle(partialTicks) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
        }
        Pair<ResourceLocation, BoatModel> boatResources = this.boatResources.get((Object)entity.getUGBoatType());
        ResourceLocation texture = (ResourceLocation)boatResources.getFirst();
        BoatModel boat = (BoatModel)boatResources.getSecond();
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.mulPose(Axis.YP.rotationDegrees(90.0f));
        boat.setupAnim((Boat)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(boat.renderType(texture));
        boat.renderToBuffer(stack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        if (!entity.isUnderWater()) {
            VertexConsumer vertexconsumer1 = bufferSource.getBuffer(RenderType.waterMask());
            boat.waterPatch().render(stack, vertexconsumer1, light, OverlayTexture.NO_OVERLAY);
        }
        stack.popPose();
        super.render((Entity)entity, yaw, partialTicks, stack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(UGBoat entity) {
        return (ResourceLocation)this.boatResources.get((Object)entity.getUGBoatType()).getFirst();
    }
}

