/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGItems;

public class SlingshotFireTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer shooter, ItemStack slingshot, ItemStack ammo) {
        this.trigger(shooter, instance -> instance.matches(slingshot, ammo));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> slingshot, Optional<ItemPredicate> ammo) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(TriggerInstance::player), (App)ExtraCodecs.strictOptionalField((Codec)ItemPredicate.CODEC, (String)"slingshot").forGetter(TriggerInstance::slingshot), (App)ExtraCodecs.strictOptionalField((Codec)ItemPredicate.CODEC, (String)"ammo").forGetter(TriggerInstance::ammo)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<?> shotItem(ItemLike slingshot, ItemLike ammo) {
            return ((SlingshotFireTrigger)((Object)UGCriteria.SLINGSHOT_FIRE.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{slingshot}).build()), Optional.of(ItemPredicate.Builder.item().of(new ItemLike[]{ammo}).build())));
        }

        public static Criterion<?> shotItem(ItemLike ammo) {
            return TriggerInstance.shotItem((ItemLike)UGItems.SLINGSHOT.get(), ammo);
        }

        public boolean matches(ItemStack slingshot, ItemStack ammo) {
            if (this.slingshot.isPresent() && !this.slingshot.get().matches(slingshot)) {
                return false;
            }
            return this.ammo.isEmpty() || this.ammo.get().matches(ammo);
        }
    }
}

