/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.DepthrockPebblesBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.Droopvine;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.data.provider.UGBlockLootTableProvider;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class UGLootTables
extends LootTableProvider {
    private static final LootItemCondition.Builder SHEARS = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{Items.SHEARS}));
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(net.minecraft.world.level.block.Blocks.DRAGON_EGG, net.minecraft.world.level.block.Blocks.BEACON, net.minecraft.world.level.block.Blocks.CONDUIT, net.minecraft.world.level.block.Blocks.SKELETON_SKULL, net.minecraft.world.level.block.Blocks.WITHER_SKELETON_SKULL, net.minecraft.world.level.block.Blocks.PLAYER_HEAD, net.minecraft.world.level.block.Blocks.ZOMBIE_HEAD, net.minecraft.world.level.block.Blocks.CREEPER_HEAD, net.minecraft.world.level.block.Blocks.DRAGON_HEAD, net.minecraft.world.level.block.Blocks.SHULKER_BOX, net.minecraft.world.level.block.Blocks.BLACK_SHULKER_BOX, net.minecraft.world.level.block.Blocks.BLUE_SHULKER_BOX, net.minecraft.world.level.block.Blocks.BROWN_SHULKER_BOX, net.minecraft.world.level.block.Blocks.CYAN_SHULKER_BOX, net.minecraft.world.level.block.Blocks.GRAY_SHULKER_BOX, net.minecraft.world.level.block.Blocks.GREEN_SHULKER_BOX, net.minecraft.world.level.block.Blocks.LIGHT_BLUE_SHULKER_BOX, net.minecraft.world.level.block.Blocks.LIGHT_GRAY_SHULKER_BOX, net.minecraft.world.level.block.Blocks.LIME_SHULKER_BOX, net.minecraft.world.level.block.Blocks.MAGENTA_SHULKER_BOX, net.minecraft.world.level.block.Blocks.ORANGE_SHULKER_BOX, net.minecraft.world.level.block.Blocks.PINK_SHULKER_BOX, net.minecraft.world.level.block.Blocks.PURPLE_SHULKER_BOX, net.minecraft.world.level.block.Blocks.RED_SHULKER_BOX, net.minecraft.world.level.block.Blocks.WHITE_SHULKER_BOX, net.minecraft.world.level.block.Blocks.YELLOW_SHULKER_BOX).map(ItemLike::asItem).collect(ImmutableSet.toImmutableSet());
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public UGLootTables(PackOutput output) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(Chests::new, LootContextParamSets.CHEST), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.ENTITY)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static LootTable.Builder droopvine(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DROOPFRUIT.get()))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)Droopvine.GLOWY, true))));
    }

    private static LootTable.Builder tallGrassDrop(Block originalBlock, Block newBlock) {
        LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)newBlock).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).when(SHEARS);
        return LootTable.lootTable().withPool(LootPool.lootPool().add(builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)originalBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{originalBlock}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0)))).withPool(LootPool.lootPool().add(builder).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)originalBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))).when(LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{originalBlock}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))));
    }

    private static LootTable.Builder dropSeedsForStem(Block stem, Item stemSeed) {
        return LootTable.lootTable().withPool((LootPool.Builder)UGLootTables.withExplosionDecay((ItemLike)stem, LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)stemSeed).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)BinomialDistributionGenerator.binomial((int)3, (float)0.53333336f))))));
    }

    protected static <T extends FunctionUserBuilder<T>> T withExplosionDecay(ItemLike item, FunctionUserBuilder<T> function) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(item.asItem()) ? function.apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay()) : function.unwrap());
    }

    public static class Chests
    implements LootTableSubProvider {
        public void generate(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(new ResourceLocation("undergarden", "chests/catacombs"), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)5.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_NUGGET.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FROSTSTEEL_NUGGET.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.REGALIUM_CRYSTAL.get())).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.SLOP_BOWL.get())).setWeight(40).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)8.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_SWORD.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((NumberProvider)UniformGenerator.between((float)15.0f, (float)20.0f))).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.6f, (float)0.9f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_AXE.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((NumberProvider)UniformGenerator.between((float)15.0f, (float)20.0f))).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.6f, (float)0.9f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_SWORD.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((NumberProvider)UniformGenerator.between((float)25.0f, (float)30.0f)).allowTreasure()).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.2f, (float)0.5f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_AXE.get())).setWeight(10).apply((LootItemFunction.Builder)EnchantWithLevelsFunction.enchantWithLevels((NumberProvider)UniformGenerator.between((float)25.0f, (float)30.0f)).allowTreasure()).apply((LootItemFunction.Builder)SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)0.2f, (float)0.5f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(8)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.MAMMOTH_DISC.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RELICT_DISC.get())).setWeight(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get())).setWeight(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FORGOTTEN_NUGGET.get())).setWeight(1))));
        }
    }

    public static class Entities
    extends EntityLootSubProvider {
        public Entities() {
            super(FeatureFlags.REGISTRY.allFlags());
        }

        public void generate() {
            this.add((EntityType)UGEntityTypes.ROTLING.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.ROTWALKER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.ROTBEAST.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)8.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).when(LootItemKilledByPlayerCondition.killedByPlayer()))));
            this.add((EntityType)UGEntityTypes.DWELLER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_DWELLER_MEAT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.GWIBLING.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_GWIBLING.get())).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE)))).when(LootItemKilledByPlayerCondition.killedByPlayer())).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE_MEAL)).when(LootItemRandomChanceCondition.randomChance((float)0.05f))));
            this.add((EntityType)UGEntityTypes.BRUTE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BRUTE_TUSK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.SCINTLING.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.GOO_BALL.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))))));
            this.add((EntityType)UGEntityTypes.GLOOMPER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.RAW_GLOOMPER_LEG.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)SmeltItemFunction.smelted().when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)ENTITY_ON_FIRE))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.STONEBORN.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            this.add((EntityType)UGEntityTypes.NARGOYLE.get(), LootTable.lootTable());
            this.add((EntityType)UGEntityTypes.MUNCHER.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)3.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.CLOGGRUM_NUGGET.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FROSTSTEEL_NUGGET.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))));
            this.add((EntityType)UGEntityTypes.SPLOOGIE.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
            this.add((EntityType)UGEntityTypes.GWIB.get(), LootTable.lootTable());
            this.add((EntityType)UGEntityTypes.MOG.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.MOGMOSS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.SMOG_MOG.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)6.0f))).apply((LootItemFunction.Builder)LootingEnchantFunction.lootingMultiplier((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLUE_MOGMOSS.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))))));
            this.add((EntityType)UGEntityTypes.FORGOTTEN.get(), LootTable.lootTable());
            this.add((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.FORGOTTEN_NUGGET.get())).when(LootItemKilledByPlayerCondition.killedByPlayer())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)4.0f, (float)16.0f))))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return UGEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get);
        }
    }

    public static class Blocks
    extends UGBlockLootTableProvider {
        protected void generate() {
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEEPSOIL);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPSOIL_FARMLAND, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.add((Block)UGBlocks.UNDERBEAN_BUSH.get(), LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)UnderbeanBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)UnderbeanBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))));
            this.add((Block)UGBlocks.BLISTERBERRY_BUSH.get(), LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 3))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))).withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlisterberryBushBlock.AGE, 2))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))));
            this.add((Block)UGBlocks.DITCHBULB_PLANT.get(), LootTable.lootTable().withPool(LootPool.lootPool().when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)UGBlocks.DITCHBULB_PLANT.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DitchbulbBlock.AGE, 1))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DITCHBULB.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Enchantment)Enchantments.BLOCK_FORTUNE))));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.add((Block)UGBlocks.TALL_DEEPTURF.get(), block -> UGLootTables.tallGrassDrop(block, (Block)UGBlocks.DEEPTURF.get()));
            this.add((Block)UGBlocks.TALL_SHIMMERWEED.get(), block -> UGLootTables.tallGrassDrop(block, (Block)UGBlocks.SHIMMERWEED.get()));
            this.add((Block)UGBlocks.DEEPTURF.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)UGBlocks.SHIMMERWEED.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)UGBlocks.ASHEN_DEEPTURF.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SAPLING);
            this.add((Block)UGBlocks.SMOGSTEM_LEAVES.get(), leaves -> this.createLeavesDrops((Block)leaves, (Block)UGBlocks.SMOGSTEM_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SAPLING);
            this.add((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), leaves -> Blocks.createSilkTouchOrShearsDispatchTable((Block)leaves, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)leaves, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_SAPLING.get())))).when(BonusLevelTableCondition.bonusLevelFlatChance((Enchantment)Enchantments.BLOCK_FORTUNE, (float[])DEFAULT_SAPLING_DROP_RATES))).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_NO_SHEARS_OR_SILK_TOUCH).add(((LootPoolSingletonContainer.Builder)this.applyExplosionDecay((ItemLike)leaves, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance((Enchantment)Enchantments.BLOCK_FORTUNE, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))));
            this.add((Block)UGBlocks.GRONGLE_LEAVES.get(), leaves -> this.createLeavesDrops((Block)leaves, (Block)UGBlocks.GRONGLE_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CARVED_GLOOMGOURD);
            this.add((Block)UGBlocks.DEPTHROCK_PEBBLES.get(), pebble -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)UGBlocks.DEPTHROCK_PEBBLES.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)pebble).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DepthrockPebblesBlock.PEBBLES, 1)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)pebble).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DepthrockPebblesBlock.PEBBLES, 2))))))));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOM_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_BRICK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SMOGSTEM_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.WIGGLEWOOD_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.UTHERIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BARS);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLITTERKELP, (ItemLike)UGItems.GLITTERKELP.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLITTERKELP_PLANT, (ItemLike)UGItems.GLITTERKELP.get());
            this.add((Block)UGBlocks.SMOGSTEM_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.add((Block)UGBlocks.WIGGLEWOOD_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_TRAPDOOR);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.SMOG_VENT, (Supplier<? extends ItemLike>)UGBlocks.DEPTHROCK);
            this.add((Block)UGBlocks.GOO.get(), goo -> this.createSingleItemTableWithSilkTouch((Block)goo, (ItemLike)UGItems.GOO_BALL.get(), (NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.ASHEN_DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.REGALIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_TORCH);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SHARD_WALL_TORCH, (ItemLike)UGBlocks.SHARD_TORCH.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.COARSE_DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SAPLING);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.GRONGLE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE_GATE);
            this.add((Block)UGBlocks.GRONGLE_DOOR.get(), block -> this.createSinglePropConditionTable((Block)block, (Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_WOOD);
            this.add((Block)UGBlocks.GLOOMGOURD_STEM.get(), stem -> this.createStemDrops((Block)stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.add((Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), stem -> UGLootTables.dropSeedsForStem(stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_SHIVERSTONE_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_WALL);
            this.add((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.BLOOD_MUSHROOM.get()));
            this.add((Block)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), block -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get())).when(HAS_SILK_TOUCH)).otherwise((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGItems.BLOOD_GLOBULE.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f))))).append((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)-6.0f, (float)2.0f))).apply((LootItemFunction.Builder)LimitCount.limitCount((IntRange)IntRange.lowerBound((int)0))))))));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM_STEM);
            this.add((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM_STEM);
            this.add((Block)UGBlocks.VEIL_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.VEIL_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM_STEM);
            this.add((Block)UGBlocks.INK_MUSHROOM_CAP.get(), mushroom -> this.createMushroomBlockDrop((Block)mushroom, (ItemLike)UGBlocks.INK_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM_STEM);
            this.add((Block)UGBlocks.SEEPING_INK.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FORGOTTEN_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_SHIVERSTONE_BRICKS);
            this.dropPottedContents((Block)UGBlocks.POTTED_SMOGSTEM_SAPLING.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_WIGGLEWOOD_SAPLING.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_SHIMMERWEED.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_INDIGO_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_VEIL_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_INK_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_BLOOD_MUSHROOM.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_GRONGLE_SAPLING.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_AMOROUS_BRISTLE.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_MISERABELL.get());
            this.dropPottedContents((Block)UGBlocks.POTTED_BUTTERBUNCH.get());
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.FROZEN_DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.add((Block)UGBlocks.FROZEN_DEEPTURF.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_SIGN, (ItemLike)UGBlocks.SMOGSTEM_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_SIGN, (ItemLike)UGBlocks.WIGGLEWOOD_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_SIGN, (ItemLike)UGBlocks.GRONGLE_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_HANGING_SIGN, (ItemLike)UGBlocks.SMOGSTEM_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_HANGING_SIGN, (ItemLike)UGBlocks.WIGGLEWOOD_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_HANGING_SIGN, (ItemLike)UGBlocks.GRONGLE_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GOO_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SEDIMENT);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS_PANE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILES);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILES);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_SLAB);
            this.add((Block)UGBlocks.DEPTHROCK_BED.get(), bed -> this.createSinglePropConditionTable((Block)bed, (Property)BedBlock.PART, (Comparable)BedPart.HEAD));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.MOGMOSS_RUG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLUE_MOGMOSS_RUG);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_COAL_ORE, Items.COAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_COAL_ORE, Items.COAL);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.DEPTHROCK_IRON_ORE, Items.IRON_NUGGET);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_IRON_ORE, Items.IRON_NUGGET);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.DEPTHROCK_GOLD_ORE, Items.GOLD_NUGGET);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_DIAMOND_ORE, Items.DIAMOND);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_DIAMOND_ORE, Items.DIAMOND);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_CLOGGRUM_ORE, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE, (Supplier<? extends Item>)UGItems.RAW_FROSTSTEEL);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_REGALIUM_ORE, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_REGALIUM_ORE, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.RAW_CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.RAW_FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_LANTERN);
            this.add((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
            this.add((Block)UGBlocks.DROOPVINE.get(), UGLootTables::droopvine);
            this.add((Block)UGBlocks.DROOPVINE_PLANT.get(), UGLootTables::droopvine);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLET);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.AMOROUS_BRISTLE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.MISERABELL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BUTTERBUNCH);
            this.dropOther((Supplier<? extends Block>)UGBlocks.VIRULENT_MIX_CAULDRON, (ItemLike)Items.CAULDRON);
            this.add((Block)UGBlocks.MUSHROOM_VEIL.get(), x$0 -> BlockLootSubProvider.createShearsOnlyDrop((ItemLike)x$0));
        }

        protected Iterable<Block> getKnownBlocks() {
            return UGBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

