/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data.provider;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.common.data.LanguageProvider;
import quek.undergarden.data.provider.LangConversionHelper;
import quek.undergarden.data.provider.LangFormatSplitter;

public abstract class UGLangProvider
extends LanguageProvider {
    private final PackOutput output;
    public final Map<String, String> upsideDownEntries = new HashMap<String, String>();

    public UGLangProvider(PackOutput output) {
        super(output, "undergarden", "en_us");
        this.output = output;
    }

    public void add(String key, String value) {
        super.add(key, value);
        List<LangFormatSplitter.Component> splitEnglish = LangFormatSplitter.split(value);
        this.upsideDownEntries.put(key, LangConversionHelper.convertComponents(splitEnglish));
    }

    protected void addAdvTitle(String advancementTitle, String name) {
        this.add("advancement.undergarden." + advancementTitle + ".title", name);
    }

    protected void addAdvDesc(String advancementTitle, String name) {
        this.add("advancement.undergarden." + advancementTitle + ".desc", name);
    }

    protected void addSubtitle(String category, String subtitleName, String name) {
        this.add("subtitles." + category + "." + subtitleName, name);
    }

    protected void addBiome(ResourceKey<Biome> biomeKey, String name) {
        this.add("biome.undergarden." + biomeKey.location().getPath(), name);
    }

    protected void addDeath(String deathName, String name) {
        this.add("death.attack." + deathName, name);
    }

    protected void addPotion(Supplier<? extends Potion> potion, String name) {
        this.add("item.minecraft.potion.effect." + BuiltInRegistries.POTION.getKey((Object)potion.get()).getPath(), "Potion of " + name);
        this.add("item.minecraft.splash_potion.effect." + BuiltInRegistries.POTION.getKey((Object)potion.get()).getPath(), "Splash Potion of " + name);
        this.add("item.minecraft.lingering_potion.effect." + BuiltInRegistries.POTION.getKey((Object)potion.get()).getPath(), "Lingering Potion of " + name);
        this.add("item.minecraft.tipped_arrow.effect." + BuiltInRegistries.POTION.getKey((Object)potion.get()).getPath(), "Arrow of " + name);
    }

    protected void addConfig(String configName, String name) {
        this.add("config.undergarden." + configName, name);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        CompletableFuture languageGen = super.run(cache);
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        futuresBuilder.add((Object)languageGen);
        JsonObject upsideDownFile = new JsonObject();
        this.upsideDownEntries.forEach((arg_0, arg_1) -> ((JsonObject)upsideDownFile).addProperty(arg_0, arg_1));
        futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)upsideDownFile, (Path)this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK).resolve("undergarden").resolve("lang").resolve("en_ud.json")));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }
}

