/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidType;
import quek.undergarden.entity.projectile.MinionProjectile;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class Minion
extends AbstractGolem
implements RangedAttackMob {
    public Minion(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.5, 20, 10.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, entity -> entity.getType() != UGEntityTypes.STONEBORN.get() && entity instanceof Enemy || entity.getType().is(UGTags.Entities.ROTSPAWN) || entity.getType().is(UGTags.Entities.CAVERN_CREATURE)));
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return 1.0f;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return AbstractGolem.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ARMOR, 10.0).add(Attributes.ARMOR_TOUGHNESS, 5.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.MINION_DEATH.get();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        MinionProjectile projectile = new MinionProjectile(this.level(), (LivingEntity)this);
        double xDistance = target.getX() - this.getX();
        double yDistance = target.getY(0.3333333333333333) - projectile.getY();
        double zDistance = target.getZ() - this.getZ();
        double yMath = Mth.sqrt((float)((float)(xDistance * xDistance + zDistance * zDistance)));
        projectile.shoot(xDistance, yDistance + yMath * 0.1, zDistance, 1.6f, 1.0f);
        this.playSound((SoundEvent)UGSoundEvents.MINION_SHOOT.get(), 1.0f, this.getVoicePitch());
        this.level().addFreshEntity((Entity)projectile);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        Item item = itemstack.getItem();
        if (item != UGItems.FORGOTTEN_NUGGET.get()) {
            return InteractionResult.PASS;
        }
        float health = this.getHealth();
        this.heal(5.0f);
        if (this.getHealth() == health) {
            return InteractionResult.PASS;
        }
        this.playSound((SoundEvent)UGSoundEvents.MINION_REPAIR.get(), 1.0f, 2.0f);
        if (!player.getAbilities().instabuild) {
            itemstack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }
}

