/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.EventHooks;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class Scintling
extends Animal {
    public Scintling(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.xpReward = 0;
        this.setMaxUpStep(1.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, RotspawnMonster.class, 12.0f, 1.2, 1.4));
        this.goalSelector.addGoal(1, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.BLISTERBERRY.get()}), false));
        this.goalSelector.addGoal(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(1, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 2.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public static boolean canScintlingSpawn(EntityType<? extends Animal> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(UGTags.Blocks.SCINTLING_SPAWNABLE_ON);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.SCINTLING_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.SCINTLING_DEATH.get();
    }

    public void aiStep() {
        super.aiStep();
        if (!EventHooks.getMobGriefingEvent((Level)this.level(), (Entity)this) || this.isBaby()) {
            return;
        }
        BlockState goo = ((Block)UGBlocks.GOO.get()).defaultBlockState();
        for (int l = 0; l < 4; ++l) {
            int x = Mth.floor((double)(this.getX() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            int y = Mth.floor((double)this.getY());
            int z = Mth.floor((double)(this.getZ() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
            BlockPos blockpos = new BlockPos(x, y, z);
            if (!this.level().isEmptyBlock(blockpos) || !goo.canSurvive((LevelReader)this.level(), blockpos)) continue;
            this.level().setBlockAndUpdate(blockpos, goo);
        }
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.SCINTLING.get()).create(this.level());
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)UGItems.BLISTERBERRY.get()}).test(stack);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.SCINTLING_STEP.get(), 0.3f, 1.0f);
    }
}

