/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.cavern;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.entity.cavern.CavernMonster;
import quek.undergarden.registry.UGSoundEvents;

public class Nargoyle
extends CavernMonster {
    public Nargoyle(EntityType<? extends CavernMonster> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.2f));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 15.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 64.0);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.NARGOYLE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.NARGOYLE_DEATH.get();
    }

    public boolean doHurtTarget(Entity entity) {
        this.playSound((SoundEvent)UGSoundEvents.NARGOYLE_ATTACK.get(), 1.0f, 1.0f);
        return super.doHurtTarget(entity);
    }

    public static class LeapAtTargetGoal
    extends Goal {
        private final Mob leaper;
        private LivingEntity leapTarget;
        private final float leapMotionY;

        public LeapAtTargetGoal(Mob mob, float leapMotionY) {
            this.leaper = mob;
            this.leapMotionY = leapMotionY;
            this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.leaper.isVehicle()) {
                return false;
            }
            this.leapTarget = this.leaper.getTarget();
            if (this.leapTarget == null) {
                return false;
            }
            double distance = this.leaper.distanceToSqr((Entity)this.leapTarget);
            if (!(distance < 4.0) && !(distance > 16.0)) {
                if (!this.leaper.onGround()) {
                    return false;
                }
                return this.leaper.getRandom().nextInt(5) == 0;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return !this.leaper.onGround();
        }

        public void start() {
            Vec3 vector3d = this.leaper.getDeltaMovement();
            Vec3 vector3d1 = new Vec3(this.leapTarget.getX() - this.leaper.getX(), 0.0, this.leapTarget.getZ() - this.leaper.getZ());
            if (vector3d1.lengthSqr() > 1.0E-7) {
                vector3d1 = vector3d1.normalize().scale(0.4).add(vector3d.scale(0.2));
            }
            this.leaper.setDeltaMovement(vector3d1.x * 2.0, (double)this.leapMotionY, vector3d1.z * 2.0);
        }
    }
}

