/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.cavern;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import quek.undergarden.entity.cavern.CavernMonster;
import quek.undergarden.entity.projectile.slingshot.DepthrockPebble;
import quek.undergarden.registry.UGSoundEvents;

public class Sploogie
extends CavernMonster
implements RangedAttackMob {
    public Sploogie(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.goalSelector.addGoal(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 40, 15.0f));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return CavernMonster.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)UGSoundEvents.SPLOOGIE_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.SPLOOGIE_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.SPLOOGIE_DEATH.get();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        DepthrockPebble pebble = new DepthrockPebble(this.level(), (LivingEntity)this);
        double xDistance = target.getX() - this.getX();
        double yDistance = target.getY(0.3333333333333333) - pebble.getY();
        double zDistance = target.getZ() - this.getZ();
        double yMath = Mth.sqrt((float)((float)(xDistance * xDistance + zDistance * zDistance)));
        pebble.shoot(xDistance, yDistance + yMath * 0.1, zDistance, 1.6f, 1.0f);
        this.playSound((SoundEvent)UGSoundEvents.SPLOOGIE_SPIT.get(), 1.0f, this.getVoicePitch());
        this.level().addFreshEntity((Entity)pebble);
    }

    protected float getStandingEyeHeight(Pose pose, EntityDimensions dimensions) {
        return 0.3f;
    }
}

