/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.stoneborn;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidType;
import quek.undergarden.criterion.StonebornTradeTrigger;
import quek.undergarden.entity.stoneborn.goals.StonebornLookAtCustomerGoal;
import quek.undergarden.entity.stoneborn.goals.StonebornTradeWithPlayerGoal;
import quek.undergarden.entity.stoneborn.trading.StonebornTrades;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class Stoneborn
extends Monster
implements NeutralMob,
Npc,
Merchant {
    protected int timeOutOfUG = 0;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private int angerTime;
    private UUID targetUuid;
    @Nullable
    private Player customer;
    @Nullable
    protected MerchantOffers offers;

    public Stoneborn(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new StonebornTradeWithPlayerGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StonebornLookAtCustomerGoal(this));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.3));
        this.goalSelector.addGoal(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 32.0f));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.ARMOR, 10.0).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.KNOCKBACK_RESISTANCE, 0.9);
    }

    public static boolean canStonebornSpawn(EntityType<? extends Monster> entity, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return level.getDifficulty() != Difficulty.PEACEFUL && random.nextInt(10) == 0 && Stoneborn.checkMobSpawnRules(entity, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)random);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        if (this.isAggressive()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_ANGRY.get();
        }
        if (this.hasCustomer()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_SPEAKING.get();
        }
        if (!this.inUndergarden()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
        }
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)UGSoundEvents.STONEBORN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)UGSoundEvents.STONEBORN_DEATH.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)UGSoundEvents.STONEBORN_STEP.get(), 1.0f, 1.0f);
    }

    protected SoundEvent getYesOrNoSound(boolean getYesSound) {
        return getYesSound ? (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get() : (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.getItem() != UGItems.STONEBORN_SPAWN_EGG.get() && this.isAlive() && !this.hasCustomer() && this.inUndergarden()) {
            if (!this.getOffers().isEmpty() && !this.level().isClientSide()) {
                this.setTradingPlayer(player);
                this.openTradingScreen(player, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, hand);
    }

    public void tick() {
        super.tick();
        if (!this.inUndergarden() && !this.isNoAi()) {
            ++this.timeOutOfUG;
            this.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 300, 0));
        } else {
            this.timeOutOfUG = 0;
        }
        if (this.timeOutOfUG > 300) {
            this.playSound((SoundEvent)UGSoundEvents.STONEBORN_CHANT.get(), 1.0f, 1.0f);
            if (!this.level().isClientSide()) {
                this.remove(Entity.RemovalReason.KILLED);
                this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 3.0f, Level.ExplosionInteraction.MOB);
            }
        }
    }

    public boolean inUndergarden() {
        return this.level().dimension() == UGDimensions.UNDERGARDEN_LEVEL;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.timeOutOfUG = tag.getInt("TimeOutOfUndergarden");
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        tag.putInt("TimeOutOfUndergarden", this.timeOutOfUG);
    }

    public int getRemainingPersistentAngerTime() {
        return this.angerTime;
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.targetUuid;
    }

    public void setPersistentAngerTarget(@Nullable UUID target) {
        this.targetUuid = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public void setTradingPlayer(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected void populateTradeData() {
        VillagerTrades.ItemListing[] trades = (VillagerTrades.ItemListing[])StonebornTrades.VAGABOND_TRADES.get(1);
        if (trades != null) {
            MerchantOffers merchantoffers = this.getOffers();
            this.addTrades(merchantoffers, trades, 4);
        }
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ItemListing[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.random.nextInt(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.getOffer((Entity)this, this.random);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    public void overrideOffers(@Nullable MerchantOffers offers) {
    }

    public void notifyTrade(MerchantOffer offer) {
        offer.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.onStonebornTrade(offer);
        Player player = this.customer;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ((StonebornTradeTrigger)((Object)UGCriteria.STONEBORN_TRADE.get())).trigger(player2, this, offer.getResult());
        }
    }

    protected void onStonebornTrade(MerchantOffer offer) {
        if (offer.shouldRewardExp()) {
            int i = 3 + this.getRandom().nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public void notifyTradeUpdated(ItemStack stack) {
        if (!this.level().isClientSide() && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.playSound(this.getYesOrNoSound(!stack.isEmpty()), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public int getVillagerXp() {
        return 0;
    }

    public void overrideXp(int xpIn) {
    }

    public boolean showProgressBar() {
        return false;
    }

    public SoundEvent getNotifyTradeSound() {
        return (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get();
    }

    public boolean isClientSide() {
        return this.level().isClientSide();
    }
}

