/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class CarvedGloomgourdItem
extends BlockItem {
    public CarvedGloomgourdItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTicks) {
                ResourceLocation overlay = new ResourceLocation("undergarden", "textures/gloomgourd_overlay.png");
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)overlay);
                Minecraft.getInstance().getTextureManager().bindForSetup(overlay);
                Tesselator tessellator = Tesselator.getInstance();
                BufferBuilder bufferbuilder = tessellator.getBuilder();
                bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                double scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
                double scaledHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
                bufferbuilder.vertex(0.0, scaledHeight, -90.0).uv(0.0f, 1.0f).endVertex();
                bufferbuilder.vertex(scaledWidth, scaledHeight, -90.0).uv(1.0f, 1.0f).endVertex();
                bufferbuilder.vertex(scaledWidth, 0.0, -90.0).uv(1.0f, 0.0f).endVertex();
                bufferbuilder.vertex(0.0, 0.0, -90.0).uv(0.0f, 0.0f).endVertex();
                tessellator.end();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        });
    }
}

