/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import quek.undergarden.block.UndergardenPortalBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGSoundEvents;

public class CatalystItem
extends Item {
    public CatalystItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
    }

    public InteractionResult useOn(UseOnContext context) {
        Iterator iterator;
        if (context.getPlayer() != null && (context.getPlayer().level().dimension() == UGDimensions.UNDERGARDEN_LEVEL || context.getPlayer().level().dimension() == Level.OVERWORLD) && (iterator = Direction.Plane.VERTICAL.iterator()).hasNext()) {
            Direction direction = (Direction)iterator.next();
            BlockPos framePos = context.getClickedPos().relative(direction);
            if (((UndergardenPortalBlock)((Object)UGBlocks.UNDERGARDEN_PORTAL.get())).trySpawnPortal((LevelAccessor)context.getLevel(), framePos)) {
                context.getLevel().playSound(context.getPlayer(), framePos, (SoundEvent)UGSoundEvents.UNDERGARDEN_PORTAL_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }
}

