/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.armor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import quek.undergarden.registry.UGArmorMaterials;
import quek.undergarden.registry.UGItems;

public class UndergardenArmorItem
extends ArmorItem {
    public UndergardenArmorItem(ArmorMaterial material, ArmorItem.Type slot) {
        super(material, slot, new Item.Properties().stacksTo(1));
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return stack.getItem().asItem() == UGItems.FROSTSTEEL_BOOTS.get();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.getItem() == UGItems.CLOGGRUM_BOOTS.get()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.cloggrum_boots").withStyle(ChatFormatting.GRAY));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (this.getMaterial() == UGArmorMaterials.FROSTSTEEL && slot == this.getEquipmentSlot()) {
            UUID uuid = (UUID)ARMOR_MODIFIER_UUID_PER_TYPE.get(this.getType());
            return ImmutableMultimap.of((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(uuid, "Froststeel slowness", -0.05, AttributeModifier.Operation.MULTIPLY_BASE), (Object)Attributes.ARMOR, (Object)new AttributeModifier(uuid, "Armor modifier", (double)UGArmorMaterials.FROSTSTEEL.getDefenseForType(this.getType()), AttributeModifier.Operation.ADDITION), (Object)Attributes.ARMOR_TOUGHNESS, (Object)new AttributeModifier(uuid, "Armor toughness", (double)UGArmorMaterials.FROSTSTEEL.getToughness(), AttributeModifier.Operation.ADDITION), (Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)UGArmorMaterials.FROSTSTEEL.getKnockbackResistance(), AttributeModifier.Operation.ADDITION));
        }
        return super.getDefaultAttributeModifiers(slot);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String layer) {
        if (slot == EquipmentSlot.LEGS) {
            return "undergarden:textures/armor/" + this.material.getName() + "_layer_2.png";
        }
        return "undergarden:textures/armor/" + this.material.getName() + "_layer_1.png";
    }
}

