/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.item.tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import quek.undergarden.registry.UGItems;

public class BattleaxeItem
extends SwordItem {
    private static final UUID ATTACK_KNOCKBACK_UUID = UUID.fromString("20D3EB3F-226F-4325-873E-9B0932E4E5C6");

    public BattleaxeItem(Tier tier, int attackDamage, float attackSpeed) {
        super(tier, attackDamage, attackSpeed, new Item.Properties().stacksTo(1).defaultDurability(tier.getUses() * 3).rarity(Rarity.EPIC));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)super.getDamage(), AttributeModifier.Operation.ADDITION), (Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)-3.4f, AttributeModifier.Operation.ADDITION), (Object)Attributes.ATTACK_KNOCKBACK, (Object)new AttributeModifier(ATTACK_KNOCKBACK_UUID, "Weapon modifier", 4.0, AttributeModifier.Operation.ADDITION));
        }
        return super.getAttributeModifiers(slot, stack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        if (stack.getItem() == UGItems.FORGOTTEN_BATTLEAXE.get()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.forgotten_sword").withStyle(ChatFormatting.GREEN));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.category.canEnchant(stack.getItem()) && enchantment != Enchantments.KNOCKBACK;
    }
}

