/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.registries.DeferredHolder;
import quek.undergarden.registry.UGConfiguredCarvers;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPlacedFeatures;
import quek.undergarden.registry.UGSoundEvents;

public class UGBiomes {
    public static final ResourceKey<Biome> ANCIENT_SEA = UGBiomes.create("ancient_sea");
    public static final ResourceKey<Biome> BARREN_ABYSS = UGBiomes.create("barren_abyss");
    public static final ResourceKey<Biome> BLOOD_MUSHROOM_BOG = UGBiomes.create("blood_mushroom_bog");
    public static final ResourceKey<Biome> DEAD_SEA = UGBiomes.create("dead_sea");
    public static final ResourceKey<Biome> DENSE_FOREST = UGBiomes.create("dense_forest");
    public static final ResourceKey<Biome> FORGOTTEN_FIELD = UGBiomes.create("forgotten_field");
    public static final ResourceKey<Biome> FROSTFIELDS = UGBiomes.create("frostfields");
    public static final ResourceKey<Biome> FROSTY_SMOGSTEM_FOREST = UGBiomes.create("frosty_smogstem_forest");
    public static final ResourceKey<Biome> GRONGLEGROWTH = UGBiomes.create("gronglegrowth");
    public static final ResourceKey<Biome> ICY_SEA = UGBiomes.create("icy_sea");
    public static final ResourceKey<Biome> INDIGO_MUSHROOM_BOG = UGBiomes.create("indigo_mushroom_bog");
    public static final ResourceKey<Biome> INK_MUSHROOM_BOG = UGBiomes.create("ink_mushroom_bog");
    public static final ResourceKey<Biome> SMOGSTEM_FOREST = UGBiomes.create("smogstem_forest");
    public static final ResourceKey<Biome> SMOG_SPIRES = UGBiomes.create("smog_spires");
    public static final ResourceKey<Biome> VEIL_MUSHROOM_BOG = UGBiomes.create("veil_mushroom_bog");
    public static final ResourceKey<Biome> WIGGLEWOOD_FOREST = UGBiomes.create("wigglewood_forest");

    private static ResourceKey<Biome> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)new ResourceLocation("undergarden", name));
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter featureGetter = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter carverGetter = context.lookup(Registries.CONFIGURED_CARVER);
        context.register(ANCIENT_SEA, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLITTERKELP_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIB.get(), 10, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIBLING.get(), 5, 3, 6)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 4477507), UGSoundEvents.SEA_AMBIENCE, UGSoundEvents.SEA_AMBIENT_ADDITION).build()).build());
        context.register(BARREN_ABYSS, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SMOG_MOG.get(), 100, 2, 4)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.2f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 0x737C77), UGSoundEvents.ABYSS_AMBIENCE, UGSoundEvents.ABYSS_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.ASH, 0.118093334f)).build()).build());
        context.register(BLOOD_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_BLOOD_MUSHROOM).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1248522, 6180396), UGSoundEvents.ABYSS_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.ASH, 0.118093334f)).build()).build());
        context.register(DEAD_SEA, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 0x737C77), UGSoundEvents.ABYSS_AMBIENCE, UGSoundEvents.ABYSS_AMBIENT_ADDITION).build()).build());
        context.register(DENSE_FOREST, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIGGLEWOOD_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SMOGSTEM_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_WIGGLEWOOD_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.AMOROUS_BRISTLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.MISERABELL_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BUTTERBUNCH_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 4224322), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.DENSE_FOREST_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.025f)).build()).build());
        context.register(FORGOTTEN_FIELD, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 0x5B755B), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.FIELDS_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.025f)).build()).build());
        context.register(FROSTFIELDS, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.ICE_PILLAR).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.ICE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.FROSTSTEEL_ORE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.FROZEN_DEEPTURF_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.14f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 14609908), UGSoundEvents.FROST_MOOD, UGSoundEvents.FROST_AMBIENCE, UGSoundEvents.FROSTFIELDS_AMBIENT_ADDITION, 0.002775).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.118093334f)).build()).build());
        context.register(FROSTY_SMOGSTEM_FOREST, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.ICE_PILLAR).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.ICE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.FROSTSTEEL_ORE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.FROZEN_DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIDE_SMOGSTEM_TREE).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.14f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 14609908), UGSoundEvents.FROST_MOOD, UGSoundEvents.FROST_AMBIENCE, UGSoundEvents.SMOGSTEM_FOREST_AMBIENT_ADDITION, 0.002775).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.118093334f)).build()).build());
        context.register(GRONGLEGROWTH, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.GRONGLEGROWTH_DELTA).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GRONGLE_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMALL_GRONGLE_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GRONGLE_BUSH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.AMOROUS_BRISTLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BUTTERBUNCH_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 4103962), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.GRONGLEGROWTH_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)UGParticleTypes.GRONGLE_SPORE.get(), 0.05f)).build()).build());
        context.register(ICY_SEA, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MiscOverworldPlacements.ICEBERG_PACKED).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.ICE_PILLAR).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.ICE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.FROSTSTEEL_ORE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLITTERKELP_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.FROZEN_DEEPTURF_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).addSpawn(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIB.get(), 10, 1, 1)).addSpawn(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIBLING.get(), 5, 3, 6)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.14f).temperatureAdjustment(Biome.TemperatureModifier.FROZEN).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 14609908), UGSoundEvents.FROST_MOOD, UGSoundEvents.SEA_AMBIENCE, UGSoundEvents.FROSTFIELDS_AMBIENT_ADDITION, 0.002775).build()).build());
        context.register(INDIGO_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.BOG_DELTA).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_INDIGO_MUSHROOM).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_BUSH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 8, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 2432083, 4212845), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.05f)).build()).build());
        context.register(INK_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.BOG_DELTA).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_INK_MUSHROOM).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x190919, 4075847), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.05f)).build()).build());
        context.register(SMOG_SPIRES, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SMOG_VENT).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.ASHEN_DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BLISTERBERRY_BUSH_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 8, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SMOG_MOG.get(), 100, 2, 4)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(2.0f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 0x737C77), UGSoundEvents.SPIRES_AMBIENCE, UGSoundEvents.SPIRES_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.ASH, 0.118093334f)).build()).build());
        context.register(SMOGSTEM_FOREST, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_INDIGO_MUSHROOM_SMOGSTEM_FOREST).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIDE_SMOGSTEM_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.AMOROUS_BRISTLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.MISERABELL_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 595225, 5928296), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.SMOGSTEM_FOREST_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.025f)).build()).build());
        context.register(VEIL_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.BOG_DELTA).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_VEIL_MUSHROOM).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 8, 8)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1643784, 7696730), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.05f)).build()).build());
        context.register(WIGGLEWOOD_FOREST, (Object)new Biome.BiomeBuilder().generationSettings(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIGGLEWOOD_TREE).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.MISERABELL_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BUTTERBUNCH_PATCH).build()).mobSpawnSettings(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).creatureGenerationProbability(0.5f).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).addSpawn(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).build()).hasPrecipitation(false).downfall(0.0f).temperature(0.8f).specialEffects(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1643784, 7304538), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.WIGGLEWOOD_FOREST_AMBIENT_ADDITION).ambientParticle(new AmbientParticleSettings((ParticleOptions)ParticleTypes.WHITE_ASH, 0.025f)).build()).build());
    }

    private static BiomeGenerationSettings.Builder addOresAndCaves(BiomeGenerationSettings.Builder builder) {
        return builder.addCarver(GenerationStep.Carving.AIR, UGConfiguredCarvers.UNDERGARDEN_CAVE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.DEEPSOIL_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.SEDIMENT_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.SHIVERSTONE_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.COAL_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.IRON_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.GOLD_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.DIAMOND_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.CLOGGRUM_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.UTHERIUM_ORE).addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.REGALIUM_ORE);
    }

    private static BiomeGenerationSettings.Builder addShroomPatches(BiomeGenerationSettings.Builder builder) {
        return builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BLOOD_MUSHROOM_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.INDIGO_MUSHROOM_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.INK_MUSHROOM_PATCH).addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.VEIL_MUSHROOM_PATCH);
    }

    private static MobSpawnSettings.Builder addCaveMobs(MobSpawnSettings.Builder builder) {
        return builder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.NARGOYLE.get(), 50, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MUNCHER.get(), 50, 1, 1)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SPLOOGIE.get(), 50, 1, 1));
    }

    private static MobSpawnSettings.Builder addRotspawn(MobSpawnSettings.Builder builder) {
        return builder.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.ROTLING.get(), 100, 2, 4)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.ROTWALKER.get(), 100, 4, 4)).addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.ROTBEAST.get(), 100, 1, 2));
    }

    private static BiomeSpecialEffects.Builder addMusicAndAmbience(BiomeSpecialEffects.Builder builder, DeferredHolder<SoundEvent, SoundEvent> ambient, DeferredHolder<SoundEvent, SoundEvent> addition) {
        return UGBiomes.addMusicAndAmbience(builder, UGSoundEvents.MOOD, ambient, addition, 0.00555);
    }

    private static BiomeSpecialEffects.Builder addMusicAndAmbience(BiomeSpecialEffects.Builder builder, DeferredHolder<SoundEvent, SoundEvent> mood, DeferredHolder<SoundEvent, SoundEvent> ambient, DeferredHolder<SoundEvent, SoundEvent> addition, double additionInterval) {
        return builder.ambientAdditionsSound(new AmbientAdditionsSettings(addition, additionInterval)).ambientMoodSound(new AmbientMoodSettings(mood, 6000, 8, 2.0)).ambientLoopSound(ambient).backgroundMusic(new Music(UGSoundEvents.UNDERGARDEN_MUSIC, 12000, 24000, true));
    }

    private static BiomeSpecialEffects.Builder generateColors(BiomeSpecialEffects.Builder builder, int skyFog, int grass) {
        return builder.skyColor(1186057).fogColor(skyFog).waterColor(342306).waterFogColor(332810).grassColorOverride(grass).foliageColorOverride(grass);
    }

    public static BiomeSource buildBiomeSource(HolderGetter<Biome> biomes) {
        return MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList((List)ImmutableList.of((Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(FORGOTTEN_FIELD)), (Object)Pair.of((Object)Climate.parameters((float)-1.0f, (float)-0.4f, (float)-0.9f, (float)-0.7f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(FROSTFIELDS)), (Object)Pair.of((Object)Climate.parameters((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(SMOGSTEM_FOREST)), (Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)-0.4f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(WIGGLEWOOD_FOREST)), (Object)Pair.of((Object)Climate.parameters((float)1.0f, (float)0.4f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(DENSE_FOREST)), (Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.9f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(GRONGLEGROWTH)), (Object)Pair.of((Object)Climate.parameters((float)-1.0f, (float)-0.4f, (float)-0.9f, (float)-0.7f, (float)-2.0f, (float)0.5f, (float)0.0f), (Object)biomes.getOrThrow(FROSTY_SMOGSTEM_FOREST)), (Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(BARREN_ABYSS)), (Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.getOrThrow(SMOG_SPIRES)), (Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0f), (Object)biomes.getOrThrow(INK_MUSHROOM_BOG)), (Object)Pair.of((Object)Climate.parameters((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0f), (Object)biomes.getOrThrow(INDIGO_MUSHROOM_BOG)), (Object)Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)-1.0f, (float)0.0f), (Object)biomes.getOrThrow(VEIL_MUSHROOM_BOG)), (Object[])new Pair[]{Pair.of((Object)Climate.parameters((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f, (float)-2.0f, (float)-1.0f, (float)0.0f), (Object)biomes.getOrThrow(BLOOD_MUSHROOM_BOG)), Pair.of((Object)Climate.parameters((Climate.Parameter)Climate.Parameter.span((float)0.0f, (float)1.0f), (Climate.Parameter)Climate.Parameter.span((float)0.0f, (float)0.4f), (Climate.Parameter)Climate.Parameter.span((float)0.0f, (float)0.9f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)2.0f), (Climate.Parameter)Climate.Parameter.span((float)-1.0f, (float)1.0f), (float)0.0f), (Object)biomes.getOrThrow(ANCIENT_SEA)), Pair.of((Object)Climate.parameters((Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (Climate.Parameter)Climate.Parameter.span((float)0.7f, (float)1.0f), (Climate.Parameter)Climate.Parameter.point((float)2.0f), (Climate.Parameter)Climate.Parameter.point((float)0.0f), (float)0.0f), (Object)biomes.getOrThrow(DEAD_SEA)), Pair.of((Object)Climate.parameters((Climate.Parameter)Climate.Parameter.point((float)-1.0f), (Climate.Parameter)Climate.Parameter.point((float)-0.4f), (Climate.Parameter)Climate.Parameter.point((float)-0.9f), (Climate.Parameter)Climate.Parameter.point((float)-0.7f), (Climate.Parameter)Climate.Parameter.point((float)2.0f), (Climate.Parameter)Climate.Parameter.span((float)0.0f, (float)0.5f), (float)0.0f), (Object)biomes.getOrThrow(ICY_SEA))})));
    }
}

