/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.BoomgourdBlock;
import quek.undergarden.block.CarvedGloomgourdBlock;
import quek.undergarden.block.CarvedGloomgourdShardBlock;
import quek.undergarden.block.CloggrumLanternBlock;
import quek.undergarden.block.DeepsoilFarmlandBlock;
import quek.undergarden.block.DeepturfBlock;
import quek.undergarden.block.DepthrockBedBlock;
import quek.undergarden.block.DepthrockPebblesBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.Droopvine;
import quek.undergarden.block.DroopvineBlock;
import quek.undergarden.block.DroopvinePlantBlock;
import quek.undergarden.block.EngorgedCapBlock;
import quek.undergarden.block.GlitterkelpBlock;
import quek.undergarden.block.GlitterkelpPlantBlock;
import quek.undergarden.block.GloomgourdBlock;
import quek.undergarden.block.GooBlock;
import quek.undergarden.block.GooLayerBlock;
import quek.undergarden.block.GrongletBlock;
import quek.undergarden.block.HangingGrongleLeavesBlock;
import quek.undergarden.block.InkCapBlock;
import quek.undergarden.block.LooseTremblecrustBlock;
import quek.undergarden.block.MushroomVeilBlock;
import quek.undergarden.block.SeepingInkBlock;
import quek.undergarden.block.ShardTorchBlock;
import quek.undergarden.block.ShardWallTorchBlock;
import quek.undergarden.block.ShimmerweedBlock;
import quek.undergarden.block.SmogVentBlock;
import quek.undergarden.block.TallDeepturfBlock;
import quek.undergarden.block.TallDeepturfVariantBlock;
import quek.undergarden.block.TallShimmerweedBlock;
import quek.undergarden.block.UGCeilingHangingSignBlock;
import quek.undergarden.block.UGFlowerBlock;
import quek.undergarden.block.UGMushroomBlock;
import quek.undergarden.block.UGSaplingBlock;
import quek.undergarden.block.UGStandingSignBlock;
import quek.undergarden.block.UGWallHangingSignBlock;
import quek.undergarden.block.UGWallSignBlock;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.block.UndergardenPortalBlock;
import quek.undergarden.block.VirulentMixBlock;
import quek.undergarden.block.VirulentMixCauldronBlock;
import quek.undergarden.client.render.blockentity.UndergardenBEWLR;
import quek.undergarden.item.CarvedGloomgourdItem;
import quek.undergarden.item.tool.slingshot.GrongletItem;
import quek.undergarden.registry.UGConfiguredFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundTypes;
import quek.undergarden.registry.UGWoodStuff;
import quek.undergarden.world.gen.tree.UGTreeGrowers;

public class UGBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"undergarden");
    public static final DeferredBlock<Block> UNDERGARDEN_PORTAL = BLOCKS.register("undergarden_portal", UndergardenPortalBlock::new);
    public static final DeferredBlock<Block> SHARD_TORCH = UGBlocks.register("shard_torch", () -> new ShardTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TORCH).lightLevel(state -> 6)));
    public static final DeferredBlock<Block> SHARD_WALL_TORCH = BLOCKS.register("shard_wall_torch", () -> new ShardWallTorchBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).lightLevel(state -> 6)));
    public static final DeferredBlock<Block> DEPTHROCK = UGBlocks.register("depthrock", () -> new Block(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.TERRACOTTA_LIGHT_GREEN).strength(1.5f, 6.0f).sound(SoundType.BASALT).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_DEPTHROCK = UGBlocks.register("polished_depthrock", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<Block> DEPTHROCK_BRICKS = UGBlocks.register("depthrock_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<Block> CRACKED_DEPTHROCK_BRICKS = UGBlocks.register("cracked_depthrock_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<Block> CHISELED_DEPTHROCK_BRICKS = UGBlocks.register("chiseled_depthrock_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<Block> DEPTHROCK_TILES = UGBlocks.register("depthrock_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<StairBlock> DEPTHROCK_STAIRS = UGBlocks.register("depthrock_stairs", () -> new StairBlock(() -> ((Block)DEPTHROCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<StairBlock> POLISHED_DEPTHROCK_STAIRS = UGBlocks.register("polished_depthrock_stairs", () -> new StairBlock(() -> ((Block)POLISHED_DEPTHROCK.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_DEPTHROCK.get()))));
    public static final DeferredBlock<StairBlock> DEPTHROCK_BRICK_STAIRS = UGBlocks.register("depthrock_brick_stairs", () -> new StairBlock(() -> ((Block)DEPTHROCK_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK_BRICKS.get()))));
    public static final DeferredBlock<StairBlock> DEPTHROCK_TILE_STAIRS = UGBlocks.register("depthrock_tile_stairs", () -> new StairBlock(() -> ((Block)DEPTHROCK_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK_TILES.get()))));
    public static final DeferredBlock<SlabBlock> DEPTHROCK_SLAB = UGBlocks.register("depthrock_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<SlabBlock> POLISHED_DEPTHROCK_SLAB = UGBlocks.register("polished_depthrock_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_DEPTHROCK.get()))));
    public static final DeferredBlock<SlabBlock> DEPTHROCK_BRICK_SLAB = UGBlocks.register("depthrock_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK_BRICKS.get()))));
    public static final DeferredBlock<SlabBlock> DEPTHROCK_TILE_SLAB = UGBlocks.register("depthrock_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<WallBlock> DEPTHROCK_WALL = UGBlocks.register("depthrock_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<WallBlock> POLISHED_DEPTHROCK_WALL = UGBlocks.register("polished_depthrock_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)POLISHED_DEPTHROCK.get()))));
    public static final DeferredBlock<WallBlock> DEPTHROCK_BRICK_WALL = UGBlocks.register("depthrock_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK_BRICKS.get()))));
    public static final DeferredBlock<ButtonBlock> DEPTHROCK_BUTTON = UGBlocks.register("depthrock_button", () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).noCollission()));
    public static final DeferredBlock<PressurePlateBlock> DEPTHROCK_PRESSURE_PLATE = UGBlocks.register("depthrock_pressure_plate", () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).noCollission()));
    public static final DeferredBlock<Block> SHIVERSTONE = UGBlocks.register("shiverstone", () -> new Block(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.GLOW_LICHEN).strength(3.5f, 12.0f).sound(SoundType.NETHER_BRICKS).requiresCorrectToolForDrops().friction(0.98f)));
    public static final DeferredBlock<Block> SHIVERSTONE_BRICKS = UGBlocks.register("shiverstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get()))));
    public static final DeferredBlock<Block> CRACKED_SHIVERSTONE_BRICKS = UGBlocks.register("cracked_shiverstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get()))));
    public static final DeferredBlock<Block> CHISELED_SHIVERSTONE_BRICKS = UGBlocks.register("chiseled_shiverstone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get()))));
    public static final DeferredBlock<StairBlock> SHIVERSTONE_STAIRS = UGBlocks.register("shiverstone_stairs", () -> new StairBlock(() -> ((Block)SHIVERSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get()))));
    public static final DeferredBlock<StairBlock> SHIVERSTONE_BRICK_STAIRS = UGBlocks.register("shiverstone_brick_stairs", () -> new StairBlock(() -> ((Block)SHIVERSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE_BRICKS.get()))));
    public static final DeferredBlock<SlabBlock> SHIVERSTONE_SLAB = UGBlocks.register("shiverstone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get()))));
    public static final DeferredBlock<SlabBlock> SHIVERSTONE_BRICK_SLAB = UGBlocks.register("shiverstone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE_BRICKS.get()))));
    public static final DeferredBlock<WallBlock> SHIVERSTONE_WALL = UGBlocks.register("shiverstone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get()))));
    public static final DeferredBlock<WallBlock> SHIVERSTONE_BRICK_WALL = UGBlocks.register("shiverstone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE_BRICKS.get()))));
    public static final DeferredBlock<ButtonBlock> SHIVERSTONE_BUTTON = UGBlocks.register("shiverstone_button", () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).noCollission()));
    public static final DeferredBlock<PressurePlateBlock> SHIVERSTONE_PRESSURE_PLATE = UGBlocks.register("shiverstone_pressure_plate", () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).noCollission()));
    public static final DeferredBlock<Block> TREMBLECRUST = UGBlocks.register("tremblecrust", () -> new Block(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.DEEPSLATE).strength(6.0f, 24.0f).sound(SoundType.STONE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> LOOSE_TREMBLECRUST = UGBlocks.register("loose_tremblecrust", () -> new LooseTremblecrustBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get())).strength(3.0f, 24.0f).noLootTable()));
    public static final DeferredBlock<Block> TREMBLECRUST_BRICKS = UGBlocks.register("tremblecrust_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get())).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRACKED_TREMBLECRUST_BRICKS = UGBlocks.register("cracked_tremblecrust_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST_BRICKS.get()))));
    public static final DeferredBlock<Block> CHISELED_TREMBLECRUST_BRICKS = UGBlocks.register("chiseled_tremblecrust_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST_BRICKS.get()))));
    public static final DeferredBlock<StairBlock> TREMBLECRUST_STAIRS = UGBlocks.register("tremblecrust_stairs", () -> new StairBlock(() -> ((Block)TREMBLECRUST.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get()))));
    public static final DeferredBlock<StairBlock> TREMBLECRUST_BRICK_STAIRS = UGBlocks.register("tremblecrust_brick_stairs", () -> new StairBlock(() -> ((Block)TREMBLECRUST_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST_BRICKS.get()))));
    public static final DeferredBlock<SlabBlock> TREMBLECRUST_SLAB = UGBlocks.register("tremblecrust_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get()))));
    public static final DeferredBlock<SlabBlock> TREMBLECRUST_BRICK_SLAB = UGBlocks.register("tremblecrust_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST_BRICKS.get()))));
    public static final DeferredBlock<WallBlock> TREMBLECRUST_WALL = UGBlocks.register("tremblecrust_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get()))));
    public static final DeferredBlock<WallBlock> TREMBLECRUST_BRICK_WALL = UGBlocks.register("tremblecrust_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST_BRICKS.get()))));
    public static final DeferredBlock<ButtonBlock> TREMBLECRUST_BUTTON = UGBlocks.register("tremblecrust_button", () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get())).noCollission()));
    public static final DeferredBlock<PressurePlateBlock> TREMBLECRUST_PRESSURE_PLATE = UGBlocks.register("tremblecrust_pressure_plate", () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get())).noCollission()));
    public static final DeferredBlock<Block> DEPTHROCK_COAL_ORE = UGBlocks.register("depthrock_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_COAL_ORE = UGBlocks.register("shiverstone_coal_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEPTHROCK_IRON_ORE = UGBlocks.register("depthrock_iron_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_IRON_ORE = UGBlocks.register("shiverstone_iron_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEPTHROCK_GOLD_ORE = UGBlocks.register("depthrock_gold_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEPTHROCK_DIAMOND_ORE = UGBlocks.register("depthrock_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_DIAMOND_ORE = UGBlocks.register("shiverstone_diamond_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEPTHROCK_CLOGGRUM_ORE = UGBlocks.register("depthrock_cloggrum_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_CLOGGRUM_ORE = UGBlocks.register("shiverstone_cloggrum_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_FROSTSTEEL_ORE = UGBlocks.register("shiverstone_froststeel_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEPTHROCK_UTHERIUM_ORE = UGBlocks.register("depthrock_utherium_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_UTHERIUM_ORE = UGBlocks.register("shiverstone_utherium_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> TREMBLECRUST_UTHERIUM_ORE = UGBlocks.register("tremblecrust_utherium_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)4, (int)8), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)TREMBLECRUST.get())).strength(7.0f, 24.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEPTHROCK_REGALIUM_ORE = UGBlocks.register("depthrock_regalium_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).strength(3.0f, 6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SHIVERSTONE_REGALIUM_ORE = UGBlocks.register("shiverstone_regalium_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SHIVERSTONE.get())).strength(4.5f, 12.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> RAW_CLOGGRUM_BLOCK = UGBlocks.register("raw_cloggrum_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> RAW_FROSTSTEEL_BLOCK = UGBlocks.register("raw_froststeel_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_STEM).requiresCorrectToolForDrops().strength(5.0f, 6.0f)));
    public static final DeferredBlock<Block> CLOGGRUM_BLOCK = UGBlocks.register("cloggrum_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> FROSTSTEEL_BLOCK = UGBlocks.register("froststeel_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.WARPED_STEM).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> UTHERIUM_BLOCK = UGBlocks.register("utherium_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> REGALIUM_BLOCK = UGBlocks.register("regalium_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.GOLD).requiresCorrectToolForDrops().strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> FORGOTTEN_BLOCK = UGBlocks.register("forgotten_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.GRASS).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).sound(SoundType.NETHERITE_BLOCK)));
    public static final DeferredBlock<Block> DEEPTURF_BLOCK = UGBlocks.register("deepturf_block", () -> new DeepturfBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_GREEN).randomTicks().strength(0.6f).sound(SoundType.GRASS)));
    public static final DeferredBlock<Block> ASHEN_DEEPTURF_BLOCK = UGBlocks.register("ashen_deepturf_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLACK).randomTicks().strength(0.6f).sound(SoundType.GRASS)));
    public static final DeferredBlock<Block> FROZEN_DEEPTURF_BLOCK = UGBlocks.register("frozen_deepturf_block", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).randomTicks().strength(0.6f).sound(SoundType.GRASS)));
    public static final DeferredBlock<Block> DEEPSOIL = UGBlocks.register("deepsoil", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIRT)));
    public static final DeferredBlock<Block> COARSE_DEEPSOIL = UGBlocks.register("coarse_deepsoil", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEEPSOIL.get()))));
    public static final DeferredBlock<Block> DEEPSOIL_FARMLAND = UGBlocks.register("deepsoil_farmland", () -> new DeepsoilFarmlandBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FARMLAND)));
    public static final DeferredBlock<Block> GOO = UGBlocks.register("goo", () -> new GooLayerBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_YELLOW).replaceable().pushReaction(PushReaction.DESTROY).randomTicks().strength(0.1f).requiresCorrectToolForDrops().sound(SoundType.SNOW).isViewBlocking((state, getter, pos) -> false).sound(SoundType.SLIME_BLOCK).noOcclusion().noCollission()));
    public static final DeferredBlock<Block> GOO_BLOCK = UGBlocks.register("goo_block", () -> new GooBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).friction(0.8f).sound(SoundType.SLIME_BLOCK).noOcclusion()));
    public static final DeferredBlock<Block> SMOG_VENT = UGBlocks.register("smog_vent", () -> new SmogVentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get())).lightLevel(state -> 10)));
    public static final DeferredBlock<Block> SEDIMENT = UGBlocks.register("sediment", () -> new Block(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.SNARE).mapColor(MapColor.DEEPSLATE).strength(0.5f).sound(SoundType.SAND)));
    public static final DeferredBlock<Block> SEDIMENT_GLASS = UGBlocks.register("sediment_glass", () -> new TransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final DeferredBlock<Block> SEDIMENT_GLASS_PANE = UGBlocks.register("sediment_glass_pane", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS_PANE)));
    public static final DeferredBlock<Block> CLOGGRUM_BARS = UGBlocks.register("cloggrum_bars", () -> new IronBarsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BARS)));
    public static final DeferredBlock<Block> CLOGGRUM_TILES = UGBlocks.register("cloggrum_tiles", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CLOGGRUM_BLOCK.get()))));
    public static final DeferredBlock<StairBlock> CLOGGRUM_TILE_STAIRS = UGBlocks.register("cloggrum_tile_stairs", () -> new StairBlock(() -> ((Block)CLOGGRUM_TILES.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CLOGGRUM_TILES.get()))));
    public static final DeferredBlock<SlabBlock> CLOGGRUM_TILE_SLAB = UGBlocks.register("cloggrum_tile_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)CLOGGRUM_TILES.get()))));
    public static final DeferredBlock<BedBlock> DEPTHROCK_BED = UGBlocks.register("depthrock_bed", () -> new DepthrockBedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)DEPTHROCK.get()))));
    public static final DeferredBlock<WoolCarpetBlock> MOGMOSS_RUG = UGBlocks.register("mogmoss_rug", () -> new WoolCarpetBlock(DyeColor.LIME, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CARPET)));
    public static final DeferredBlock<WoolCarpetBlock> BLUE_MOGMOSS_RUG = UGBlocks.register("blue_mogmoss_rug", () -> new WoolCarpetBlock(DyeColor.BLUE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_CARPET)));
    public static final DeferredBlock<Block> CLOGGRUM_LANTERN = UGBlocks.register("cloggrum_lantern", () -> new CloggrumLanternBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LANTERN).pushReaction(PushReaction.DESTROY)));
    public static final DeferredBlock<Block> AMOROUS_BRISTLE = UGBlocks.register("amorous_bristle", () -> new UGFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY)));
    public static final DeferredBlock<Block> MISERABELL = UGBlocks.register("miserabell", () -> new UGFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CORNFLOWER)));
    public static final DeferredBlock<Block> BUTTERBUNCH = UGBlocks.register("butterbunch", () -> new UGFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final DeferredBlock<Block> UNDERBEAN_BUSH = BLOCKS.register("underbean_bush", () -> new UnderbeanBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final DeferredBlock<Block> BLISTERBERRY_BUSH = BLOCKS.register("blisterberry_bush", () -> new BlisterberryBushBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH).lightLevel(state -> 6)));
    public static final DeferredBlock<Block> DEEPTURF = UGBlocks.register("deepturf", () -> new TallDeepturfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final DeferredBlock<Block> ASHEN_DEEPTURF = UGBlocks.register("ashen_deepturf", () -> new TallDeepturfVariantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final DeferredBlock<Block> FROZEN_DEEPTURF = UGBlocks.register("frozen_deepturf", () -> new TallDeepturfVariantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final DeferredBlock<Block> TALL_DEEPTURF = UGBlocks.register("tall_deepturf", () -> new DoublePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final DeferredBlock<Block> SHIMMERWEED = UGBlocks.register("shimmerweed", () -> new ShimmerweedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).lightLevel(state -> 12)));
    public static final DeferredBlock<Block> TALL_SHIMMERWEED = UGBlocks.register("tall_shimmerweed", () -> new TallShimmerweedBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS).lightLevel(state -> 14)));
    public static final DeferredBlock<Block> DITCHBULB_PLANT = BLOCKS.register("ditchbulb_plant", () -> new DitchbulbBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS).randomTicks().lightLevel(state -> (Integer)state.getValue((Property)DitchbulbBlock.AGE) == 1 ? 6 : 0)));
    public static final DeferredBlock<Block> GLOOMGOURD = UGBlocks.register("gloomgourd", () -> new GloomgourdBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).pushReaction(PushReaction.DESTROY).strength(1.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> CARVED_GLOOMGOURD = UGBlocks.register("carved_gloomgourd", () -> new CarvedGloomgourdBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).pushReaction(PushReaction.DESTROY).strength(1.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> GLOOM_O_LANTERN = UGBlocks.register("gloom_o_lantern", () -> new CarvedGloomgourdBlock(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).pushReaction(PushReaction.DESTROY).strength(1.0f).sound(SoundType.WOOD).lightLevel(state -> 15)));
    public static final DeferredBlock<Block> SHARD_O_LANTERN = UGBlocks.register("shard_o_lantern", () -> new CarvedGloomgourdShardBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GLOOM_O_LANTERN.get())).lightLevel(state -> 6)));
    public static final DeferredBlock<Block> BOOMGOURD = UGBlocks.register("boomgourd", () -> new BoomgourdBlock(BlockBehaviour.Properties.of().ignitedByLava().mapColor(MapColor.COLOR_PURPLE).strength(1.0f).sound(SoundType.WOOD)));
    public static final ResourceKey<Block> GLOOMGOURD_STEM_KEY = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("undergarden", "gloomgourd_stem"));
    public static final ResourceKey<Block> ATTACHED_GLOOMGOURD_STEM_KEY = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)new ResourceLocation("undergarden", "gloomgourd_stem_attached"));
    public static final DeferredBlock<AttachedStemBlock> GLOOMGOURD_STEM_ATTACHED = BLOCKS.register("gloomgourd_stem_attached", () -> new AttachedStemBlock(GLOOMGOURD_STEM_KEY, GLOOMGOURD.getKey(), UGItems.GLOOMGOURD_SEEDS.getKey(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ATTACHED_MELON_STEM)));
    public static final DeferredBlock<StemBlock> GLOOMGOURD_STEM = BLOCKS.register("gloomgourd_stem", () -> new StemBlock(GLOOMGOURD.getKey(), ATTACHED_GLOOMGOURD_STEM_KEY, UGItems.GLOOMGOURD_SEEDS.getKey(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MELON_STEM)));
    public static final DeferredBlock<Block> DEPTHROCK_PEBBLES = BLOCKS.register("depthrock_pebbles", () -> new DepthrockPebblesBlock(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).instabreak().pushReaction(PushReaction.DESTROY).sound(SoundType.BASALT).noOcclusion().noCollission()));
    public static final DeferredBlock<GlitterkelpBlock> GLITTERKELP = BLOCKS.register("glitterkelp", () -> new GlitterkelpBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.KELP).lightLevel(state -> 10)));
    public static final DeferredBlock<GlitterkelpPlantBlock> GLITTERKELP_PLANT = BLOCKS.register("glitterkelp_plant", () -> new GlitterkelpPlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.KELP_PLANT).lightLevel(state -> 10)));
    public static final DeferredBlock<DroopvineBlock> DROOPVINE = BLOCKS.register("droopvine", () -> new DroopvineBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAVE_VINES).strength(0.1f).lightLevel(Droopvine.light())));
    public static final DeferredBlock<DroopvinePlantBlock> DROOPVINE_PLANT = BLOCKS.register("droopvine_plant", () -> new DroopvinePlantBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAVE_VINES_PLANT).strength(0.1f).lightLevel(Droopvine.light())));
    public static final DeferredBlock<Block> INDIGO_MUSHROOM = UGBlocks.register("indigo_mushroom", () -> new UGMushroomBlock(UGConfiguredFeatures.HUGE_INDIGO_MUSHROOM, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).noCollission().pushReaction(PushReaction.DESTROY).randomTicks().instabreak().sound(SoundType.GRASS).hasPostProcess((state, level, pos) -> true).lightLevel(state -> 2)));
    public static final DeferredBlock<Block> INDIGO_MUSHROOM_CAP = UGBlocks.register("indigo_mushroom_cap", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(0.2f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> INDIGO_MUSHROOM_STEM = UGBlocks.register("indigo_mushroom_stem", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLUE).strength(0.2f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> VEIL_MUSHROOM = UGBlocks.register("veil_mushroom", () -> new UGMushroomBlock(UGConfiguredFeatures.HUGE_VEIL_MUSHROOM, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PURPLE).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).hasPostProcess((state, level, pos) -> true)));
    public static final DeferredBlock<Block> VEIL_MUSHROOM_CAP = UGBlocks.register("veil_mushroom_cap", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PURPLE).strength(0.2f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> VEIL_MUSHROOM_STEM = UGBlocks.register("veil_mushroom_stem", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final DeferredBlock<Block> MUSHROOM_VEIL = UGBlocks.register("mushroom_veil", () -> new MushroomVeilBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLOW_LICHEN)));
    public static final DeferredBlock<Block> INK_MUSHROOM = UGBlocks.register("ink_mushroom", () -> new UGMushroomBlock(UGConfiguredFeatures.HUGE_INK_MUSHROOM, BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_PURPLE).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).hasPostProcess((state, level, pos) -> true)));
    public static final DeferredBlock<Block> INK_MUSHROOM_CAP = UGBlocks.register("ink_mushroom_cap", () -> new InkCapBlock(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_BLACK).strength(0.2f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> SEEPING_INK = UGBlocks.register("seeping_ink", () -> new SeepingInkBlock(BlockBehaviour.Properties.of().sound(SoundType.WET_GRASS).instabreak().noOcclusion().noCollission()));
    public static final DeferredBlock<Block> INK_MUSHROOM_STEM = UGBlocks.register("ink_mushroom_stem", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final DeferredBlock<Block> BLOOD_MUSHROOM = UGBlocks.register("blood_mushroom", () -> new UGMushroomBlock(UGConfiguredFeatures.HUGE_BLOOD_MUSHROOM, BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).noCollission().randomTicks().instabreak().sound(SoundType.GRASS).hasPostProcess((state, level, pos) -> true)));
    public static final DeferredBlock<Block> BLOOD_MUSHROOM_CAP = UGBlocks.register("blood_mushroom_cap", () -> new Block(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(0.2f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> ENGORGED_BLOOD_MUSHROOM_CAP = UGBlocks.register("engorged_blood_mushroom_cap", () -> new EngorgedCapBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_MUSHROOM_BLOCK)));
    public static final DeferredBlock<Block> BLOOD_MUSHROOM_STEM = UGBlocks.register("blood_mushroom_stem", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUSHROOM_STEM)));
    public static final DeferredBlock<SaplingBlock> SMOGSTEM_SAPLING = UGBlocks.register("smogstem_sapling", () -> new UGSaplingBlock(UGTreeGrowers.SMOGSTEM));
    public static final DeferredBlock<RotatedPillarBlock> SMOGSTEM_LOG = UGBlocks.register("smogstem_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.COLOR_GRAY).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_SMOGSTEM_LOG = UGBlocks.register("stripped_smogstem_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.COLOR_GRAY).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> SMOGSTEM_WOOD = UGBlocks.register("smogstem_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.COLOR_GRAY).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_SMOGSTEM_WOOD = UGBlocks.register("stripped_smogstem_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.COLOR_GRAY).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> SMOGSTEM_LEAVES = UGBlocks.register("smogstem_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().ignitedByLava().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_CYAN).strength(0.2f).randomTicks().sound(SoundType.AZALEA_LEAVES).noOcclusion().isValidSpawn((state, level, pos, value) -> false).isSuffocating((state, level, pos) -> false).isViewBlocking((state, level, pos) -> false)));
    public static final DeferredBlock<Block> SMOGSTEM_PLANKS = UGBlocks.register("smogstem_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_PLANKS)));
    public static final DeferredBlock<StairBlock> SMOGSTEM_STAIRS = UGBlocks.register("smogstem_stairs", () -> new StairBlock(() -> ((Block)SMOGSTEM_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOGSTEM_PLANKS.get()))));
    public static final DeferredBlock<SlabBlock> SMOGSTEM_SLAB = UGBlocks.register("smogstem_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOGSTEM_PLANKS.get()))));
    public static final DeferredBlock<FenceBlock> SMOGSTEM_FENCE = UGBlocks.register("smogstem_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_FENCE)));
    public static final DeferredBlock<FenceGateBlock> SMOGSTEM_FENCE_GATE = UGBlocks.register("smogstem_fence_gate", () -> new FenceGateBlock(UGWoodStuff.SMOGSTEM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_FENCE_GATE)));
    public static final DeferredBlock<DoorBlock> SMOGSTEM_DOOR = UGBlocks.register("smogstem_door", () -> new DoorBlock(UGWoodStuff.SMOGSTEM_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_DOOR)));
    public static final DeferredBlock<TrapDoorBlock> SMOGSTEM_TRAPDOOR = UGBlocks.register("smogstem_trapdoor", () -> new TrapDoorBlock(UGWoodStuff.SMOGSTEM_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_TRAPDOOR)));
    public static final DeferredBlock<ButtonBlock> SMOGSTEM_BUTTON = UGBlocks.register("smogstem_button", () -> new ButtonBlock(UGWoodStuff.SMOGSTEM_WOOD_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_BUTTON)));
    public static final DeferredBlock<PressurePlateBlock> SMOGSTEM_PRESSURE_PLATE = UGBlocks.register("smogstem_pressure_plate", () -> new PressurePlateBlock(UGWoodStuff.SMOGSTEM_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_PRESSURE_PLATE)));
    public static final DeferredBlock<StandingSignBlock> SMOGSTEM_SIGN = UGBlocks.register("smogstem_sign", () -> new UGStandingSignBlock(UGWoodStuff.SMOGSTEM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_SIGN)));
    public static final DeferredBlock<WallSignBlock> SMOGSTEM_WALL_SIGN = BLOCKS.register("smogstem_wall_sign", () -> new UGWallSignBlock(UGWoodStuff.SMOGSTEM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_WALL_SIGN)));
    public static final DeferredBlock<CeilingHangingSignBlock> SMOGSTEM_HANGING_SIGN = UGBlocks.register("smogstem_hanging_sign", () -> new UGCeilingHangingSignBlock(UGWoodStuff.SMOGSTEM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_HANGING_SIGN)));
    public static final DeferredBlock<WallHangingSignBlock> SMOGSTEM_WALL_HANGING_SIGN = BLOCKS.register("smogstem_wall_hanging_sign", () -> new UGWallHangingSignBlock(UGWoodStuff.SMOGSTEM_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WARPED_WALL_HANGING_SIGN)));
    public static final DeferredBlock<SaplingBlock> WIGGLEWOOD_SAPLING = UGBlocks.register("wigglewood_sapling", () -> new UGSaplingBlock(UGTreeGrowers.WIGGLEWOOD));
    public static final DeferredBlock<RotatedPillarBlock> WIGGLEWOOD_LOG = UGBlocks.register("wigglewood_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_BROWN).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_WIGGLEWOOD_LOG = UGBlocks.register("stripped_wigglewood_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_BROWN).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> WIGGLEWOOD_WOOD = UGBlocks.register("wigglewood_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_BROWN).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_WIGGLEWOOD_WOOD = UGBlocks.register("stripped_wigglewood_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().ignitedByLava().instrument(NoteBlockInstrument.BASS).mapColor(MapColor.TERRACOTTA_BROWN).strength(2.0f).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> WIGGLEWOOD_LEAVES = UGBlocks.register("wigglewood_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.of().ignitedByLava().pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_PINK).strength(0.2f).randomTicks().sound(SoundType.AZALEA_LEAVES).noOcclusion().isValidSpawn((state, level, pos, value) -> false).isSuffocating((state, level, pos) -> false).isViewBlocking((state, level, pos) -> false)));
    public static final DeferredBlock<Block> WIGGLEWOOD_PLANKS = UGBlocks.register("wigglewood_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_PLANKS)));
    public static final DeferredBlock<StairBlock> WIGGLEWOOD_STAIRS = UGBlocks.register("wigglewood_stairs", () -> new StairBlock(() -> ((Block)SMOGSTEM_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)SMOGSTEM_PLANKS.get()))));
    public static final DeferredBlock<SlabBlock> WIGGLEWOOD_SLAB = UGBlocks.register("wigglewood_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)WIGGLEWOOD_PLANKS.get()))));
    public static final DeferredBlock<FenceBlock> WIGGLEWOOD_FENCE = UGBlocks.register("wigglewood_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_FENCE)));
    public static final DeferredBlock<FenceGateBlock> WIGGLEWOOD_FENCE_GATE = UGBlocks.register("wigglewood_fence_gate", () -> new FenceGateBlock(UGWoodStuff.WIGGLEWOOD_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_FENCE_GATE)));
    public static final DeferredBlock<DoorBlock> WIGGLEWOOD_DOOR = UGBlocks.register("wigglewood_door", () -> new DoorBlock(UGWoodStuff.WIGGLEWOOD_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_DOOR)));
    public static final DeferredBlock<TrapDoorBlock> WIGGLEWOOD_TRAPDOOR = UGBlocks.register("wigglewood_trapdoor", () -> new TrapDoorBlock(UGWoodStuff.WIGGLEWOOD_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_TRAPDOOR)));
    public static final DeferredBlock<ButtonBlock> WIGGLEWOOD_BUTTON = UGBlocks.register("wigglewood_button", () -> new ButtonBlock(UGWoodStuff.WIGGLEWOOD_WOOD_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_BUTTON)));
    public static final DeferredBlock<PressurePlateBlock> WIGGLEWOOD_PRESSURE_PLATE = UGBlocks.register("wigglewood_pressure_plate", () -> new PressurePlateBlock(UGWoodStuff.WIGGLEWOOD_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_PRESSURE_PLATE)));
    public static final DeferredBlock<StandingSignBlock> WIGGLEWOOD_SIGN = UGBlocks.register("wigglewood_sign", () -> new UGStandingSignBlock(UGWoodStuff.WIGGLEWOOD_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_SIGN)));
    public static final DeferredBlock<WallSignBlock> WIGGLEWOOD_WALL_SIGN = BLOCKS.register("wigglewood_wall_sign", () -> new UGWallSignBlock(UGWoodStuff.WIGGLEWOOD_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_WALL_SIGN)));
    public static final DeferredBlock<CeilingHangingSignBlock> WIGGLEWOOD_HANGING_SIGN = UGBlocks.register("wigglewood_hanging_sign", () -> new UGCeilingHangingSignBlock(UGWoodStuff.WIGGLEWOOD_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_HANGING_SIGN)));
    public static final DeferredBlock<WallHangingSignBlock> WIGGLEWOOD_WALL_HANGING_SIGN = BLOCKS.register("wigglewood_wall_hanging_sign", () -> new UGWallHangingSignBlock(UGWoodStuff.WIGGLEWOOD_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPRUCE_WALL_HANGING_SIGN)));
    public static final DeferredBlock<Block> GRONGLE_SAPLING = UGBlocks.register("grongle_sapling", () -> new UGSaplingBlock(UGTreeGrowers.GRONGLE));
    public static final DeferredBlock<RotatedPillarBlock> GRONGLE_LOG = UGBlocks.register("grongle_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_GRONGLE_LOG = UGBlocks.register("stripped_grongle_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<RotatedPillarBlock> GRONGLE_WOOD = UGBlocks.register("grongle_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredBlock<RotatedPillarBlock> STRIPPED_GRONGLE_WOOD = UGBlocks.register("stripped_grongle_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final DeferredBlock<Block> GRONGLE_LEAVES = UGBlocks.register("grongle_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES).sound(SoundType.AZALEA_LEAVES)));
    public static final DeferredBlock<Block> HANGING_GRONGLE_LEAVES = UGBlocks.register("hanging_grongle_leaves", () -> new HangingGrongleLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GRONGLE_LEAVES.get())).noCollission().noOcclusion()));
    public static final DeferredBlock<Block> GRONGLE_PLANKS = UGBlocks.register("grongle_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)));
    public static final DeferredBlock<StairBlock> GRONGLE_STAIRS = UGBlocks.register("grongle_stairs", () -> new StairBlock(() -> ((Block)GRONGLE_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GRONGLE_PLANKS.get()))));
    public static final DeferredBlock<SlabBlock> GRONGLE_SLAB = UGBlocks.register("grongle_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)GRONGLE_PLANKS.get()))));
    public static final DeferredBlock<FenceBlock> GRONGLE_FENCE = UGBlocks.register("grongle_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)));
    public static final DeferredBlock<FenceGateBlock> GRONGLE_FENCE_GATE = UGBlocks.register("grongle_fence_gate", () -> new FenceGateBlock(UGWoodStuff.GRONGLE_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE)));
    public static final DeferredBlock<DoorBlock> GRONGLE_DOOR = UGBlocks.register("grongle_door", () -> new DoorBlock(UGWoodStuff.GRONGLE_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)));
    public static final DeferredBlock<TrapDoorBlock> GRONGLE_TRAPDOOR = UGBlocks.register("grongle_trapdoor", () -> new TrapDoorBlock(UGWoodStuff.GRONGLE_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR)));
    public static final DeferredBlock<ButtonBlock> GRONGLE_BUTTON = UGBlocks.register("grongle_button", () -> new ButtonBlock(UGWoodStuff.GRONGLE_WOOD_SET, 30, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)));
    public static final DeferredBlock<PressurePlateBlock> GRONGLE_PRESSURE_PLATE = UGBlocks.register("grongle_pressure_plate", () -> new PressurePlateBlock(UGWoodStuff.GRONGLE_WOOD_SET, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)));
    public static final DeferredBlock<StandingSignBlock> GRONGLE_SIGN = UGBlocks.register("grongle_sign", () -> new UGStandingSignBlock(UGWoodStuff.GRONGLE_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<WallSignBlock> GRONGLE_WALL_SIGN = BLOCKS.register("grongle_wall_sign", () -> new UGWallSignBlock(UGWoodStuff.GRONGLE_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN)));
    public static final DeferredBlock<CeilingHangingSignBlock> GRONGLE_HANGING_SIGN = UGBlocks.register("grongle_hanging_sign", () -> new UGCeilingHangingSignBlock(UGWoodStuff.GRONGLE_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN)));
    public static final DeferredBlock<WallHangingSignBlock> GRONGLE_WALL_HANGING_SIGN = BLOCKS.register("grongle_wall_hanging_sign", () -> new UGWallHangingSignBlock(UGWoodStuff.GRONGLE_WOOD_TYPE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN)));
    public static final DeferredBlock<Block> GRONGLET = UGBlocks.register("gronglet", () -> new GrongletBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noTerrainParticles().lightLevel(state -> 12).noOcclusion().noCollission().strength(0.0f).sound(UGSoundTypes.GRONGLET)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_SMOGSTEM_SAPLING = BLOCKS.register("potted_smogstem_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SMOGSTEM_SAPLING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_WIGGLEWOOD_SAPLING = BLOCKS.register("potted_wigglewood_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, WIGGLEWOOD_SAPLING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_GRONGLE_SAPLING = BLOCKS.register("potted_grongle_sapling", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, GRONGLE_SAPLING, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_SHIMMERWEED = BLOCKS.register("potted_shimmerweed", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SHIMMERWEED, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT).lightLevel(state -> 12)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_INDIGO_MUSHROOM = BLOCKS.register("potted_indigo_mushroom", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, INDIGO_MUSHROOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_VEIL_MUSHROOM = BLOCKS.register("potted_veil_mushroom", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, VEIL_MUSHROOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_INK_MUSHROOM = BLOCKS.register("potted_ink_mushroom", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, INK_MUSHROOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_BLOOD_MUSHROOM = BLOCKS.register("potted_blood_mushroom", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BLOOD_MUSHROOM, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_AMOROUS_BRISTLE = BLOCKS.register("potted_amorous_bristle", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, AMOROUS_BRISTLE, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_MISERABELL = BLOCKS.register("potted_miserabell", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, MISERABELL, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_BUTTERBUNCH = BLOCKS.register("potted_butterbunch", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, BUTTERBUNCH, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final DeferredBlock<LiquidBlock> VIRULENT_MIX = BLOCKS.register("virulent_mix", () -> new VirulentMixBlock((Supplier<? extends FlowingFluid>)UGFluids.VIRULENT_MIX_SOURCE, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).replaceable().pushReaction(PushReaction.DESTROY).liquid()));
    public static final DeferredBlock<Block> VIRULENT_MIX_CAULDRON = BLOCKS.register("virulent_mix_cauldron", () -> new VirulentMixCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CAULDRON).lightLevel(state -> 10).randomTicks()));

    private static <T extends Block> DeferredBlock<T> baseRegister(String name, Supplier<? extends T> block, Function<DeferredBlock<T>, Supplier<? extends Item>> item) {
        DeferredBlock register = BLOCKS.register(name, block);
        UGItems.ITEMS.register(name, item.apply(register));
        return register;
    }

    private static <B extends Block> DeferredBlock<B> register(String name, Supplier<B> block) {
        return UGBlocks.baseRegister(name, block, UGBlocks::registerBlockItem);
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(DeferredBlock<T> block) {
        return () -> {
            if (Objects.requireNonNull((Block)block.get()) == SHARD_TORCH.get()) {
                return new StandingAndWallBlockItem((Block)SHARD_TORCH.get(), (Block)SHARD_WALL_TORCH.get(), new Item.Properties(), Direction.DOWN);
            }
            if (Objects.requireNonNull((Block)block.get()) == REGALIUM_BLOCK.get() || Objects.requireNonNull((Block)block.get()) == DEPTHROCK_REGALIUM_ORE.get() || Objects.requireNonNull((Block)block.get()) == SHIVERSTONE_REGALIUM_ORE.get()) {
                return new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties().rarity(Rarity.UNCOMMON));
            }
            if (Objects.requireNonNull((Block)block.get()) == FORGOTTEN_BLOCK.get()) {
                return new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties().rarity(UGItems.FORGOTTEN));
            }
            if (Objects.requireNonNull((Block)block.get()) == DEPTHROCK_BED.get()) {
                return new BedItem(Objects.requireNonNull((Block)block.get()), new Item.Properties().stacksTo(1)){

                    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                        consumer.accept(new IClientItemExtensions(){

                            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                                return new UndergardenBEWLR();
                            }
                        });
                    }
                };
            }
            if (Objects.requireNonNull((Block)block.get()) == GRONGLET.get()) {
                return new GrongletItem(Objects.requireNonNull((Block)block.get()), new Item.Properties()){

                    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
                        consumer.accept(new IClientItemExtensions(){

                            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                                return new UndergardenBEWLR();
                            }
                        });
                    }
                };
            }
            if (Objects.requireNonNull((Block)block.get()) == CARVED_GLOOMGOURD.get()) {
                return new CarvedGloomgourdItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
            }
            if (Objects.requireNonNull((Block)block.get()) == SMOGSTEM_SIGN.get()) {
                return new SignItem(new Item.Properties().stacksTo(16), (Block)SMOGSTEM_SIGN.get(), (Block)SMOGSTEM_WALL_SIGN.get());
            }
            if (Objects.requireNonNull((Block)block.get()) == WIGGLEWOOD_SIGN.get()) {
                return new SignItem(new Item.Properties().stacksTo(16), (Block)WIGGLEWOOD_SIGN.get(), (Block)WIGGLEWOOD_WALL_SIGN.get());
            }
            if (Objects.requireNonNull((Block)block.get()) == GRONGLE_SIGN.get()) {
                return new SignItem(new Item.Properties().stacksTo(16), (Block)GRONGLE_SIGN.get(), (Block)GRONGLE_WALL_SIGN.get());
            }
            if (Objects.requireNonNull((Block)block.get()) == SMOGSTEM_HANGING_SIGN.get()) {
                return new HangingSignItem((Block)SMOGSTEM_HANGING_SIGN.get(), (Block)SMOGSTEM_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16));
            }
            if (Objects.requireNonNull((Block)block.get()) == WIGGLEWOOD_HANGING_SIGN.get()) {
                return new HangingSignItem((Block)WIGGLEWOOD_HANGING_SIGN.get(), (Block)WIGGLEWOOD_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16));
            }
            if (Objects.requireNonNull((Block)block.get()) == GRONGLE_HANGING_SIGN.get()) {
                return new HangingSignItem((Block)GRONGLE_HANGING_SIGN.get(), (Block)GRONGLE_WALL_HANGING_SIGN.get(), new Item.Properties().stacksTo(16));
            }
            return new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
        };
    }
}

