/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class UGDamageSources {
    public static final ResourceKey<DamageType> DEPTHROCK_PEBBLE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("undergarden", "depthrock_pebble"));
    public static final ResourceKey<DamageType> GOO_BALL = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("undergarden", "goo_ball"));
    public static final ResourceKey<DamageType> BLISTERBERRY_BUSH = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("undergarden", "blisterberry_bush"));
    public static final ResourceKey<DamageType> SHARD_TORCH = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("undergarden", "shard_torch"));

    public static DamageSource getShardTorchDamage(Level level, @NotNull Vec3 position) {
        return new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(SHARD_TORCH), position);
    }

    public static void bootstrap(BootstapContext<DamageType> context) {
        context.register(DEPTHROCK_PEBBLE, (Object)new DamageType("arrow", 0.1f));
        context.register(GOO_BALL, (Object)new DamageType("arrow", 0.1f));
        context.register(BLISTERBERRY_BUSH, (Object)new DamageType("blisterberry_bush", 0.1f, DamageEffects.POKING));
        context.register(SHARD_TORCH, (Object)new DamageType("shard_torch", DamageScaling.ALWAYS, 0.1f));
    }
}

