/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import quek.undergarden.entity.Boomgourd;
import quek.undergarden.entity.projectile.Blisterbomb;
import quek.undergarden.entity.projectile.slingshot.DepthrockPebble;
import quek.undergarden.entity.projectile.slingshot.GooBall;
import quek.undergarden.entity.projectile.slingshot.Gronglet;
import quek.undergarden.entity.projectile.slingshot.RottenBlisterberry;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class UGDispenserBehaviors {
    public static void register() {
        DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

            public ItemStack execute(BlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.getItem();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                ServerLevel world = source.level().getLevel();
                if (bucketitem.emptyContents(null, (Level)world, blockpos, null)) {
                    bucketitem.checkExtraContent(null, (Level)world, stack, blockpos);
                    return new ItemStack((ItemLike)Items.BUCKET);
                }
                return this.defaultBehavior.dispense(source, stack);
            }
        };
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.VIRULENT_MIX_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.GWIBLING_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new DepthrockPebble(level, position.x(), position.y(), position.z())), entity -> entity.setItem(stack));
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.GOO_BALL.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new GooBall(level, position.x(), position.y(), position.z())), entity -> entity.setItem(stack));
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new RottenBlisterberry(level, position.x(), position.y(), position.z())), entity -> entity.setItem(stack));
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGItems.BLISTERBOMB.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new Blisterbomb(level, position.x(), position.y(), position.z())), entity -> entity.setItem(stack));
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGBlocks.GRONGLET.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile getProjectile(Level level, Position position, ItemStack stack) {
                return (Projectile)Util.make((Object)((Object)new Gronglet(level, position.x(), position.y(), position.z())), entity -> entity.setItem(stack));
            }
        });
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)UGBlocks.BOOMGOURD.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                ServerLevel level = source.level().getLevel();
                BlockPos blockpos = source.pos().relative((Direction)source.state().getValue((Property)DispenserBlock.FACING));
                Boomgourd gourd = new Boomgourd((Level)level, (double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, null);
                level.addFreshEntity((Entity)gourd);
                level.playSound(null, gourd.getX(), gourd.getY(), gourd.getZ(), (SoundEvent)UGSoundEvents.BOOMGOURD_PRIMED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                level.gameEvent(null, GameEvent.ENTITY_PLACE, blockpos);
                stack.shrink(1);
                return stack;
            }
        });
    }
}

