/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import quek.undergarden.block.fluid.VirulentMixFluid;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGSoundEvents;

public class UGFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.FLUID, (String)"undergarden");
    public static final DeferredRegister<FluidType> TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.FLUID_TYPES, (String)"undergarden");
    public static final DeferredHolder<FluidType, FluidType> VIRULENT_MIX_TYPE = TYPES.register("virulent_mix", () -> new FluidType(FluidType.Properties.create().descriptionId("block.undergarden.virulent_mix").motionScale(0.00116666666).canExtinguish(true).supportsBoating(true).lightLevel(10).density(1500).temperature(600).viscosity(1000).sound(SoundActions.BUCKET_EMPTY, (SoundEvent)UGSoundEvents.BUCKET_EMPTY_VIRULENT.get()).sound(SoundActions.BUCKET_FILL, (SoundEvent)UGSoundEvents.BUCKET_FILL_VIRULENT.get()).addDripstoneDripping(0.05859375f, (ParticleOptions)UGParticleTypes.DRIPPING_VIRULENT.get(), (Block)UGBlocks.VIRULENT_MIX_CAULDRON.get(), SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return new ResourceLocation("undergarden", "fluid/virulent_mix_still");
                }

                public ResourceLocation getFlowingTexture() {
                    return new ResourceLocation("undergarden", "fluid/virulent_mix_flow");
                }

                public ResourceLocation getOverlayTexture() {
                    return new ResourceLocation("undergarden", "fluid/virulent_mix_flow");
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTicks, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.22352941f, 0.09803922f, 0.3137255f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTicks, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)0.0f);
                    RenderSystem.setShaderFogEnd((float)3.0f);
                }
            });
        }
    });
    public static final DeferredHolder<Fluid, VirulentMixFluid.Source> VIRULENT_MIX_SOURCE = FLUIDS.register("virulent_mix_source", () -> new VirulentMixFluid.Source(VIRULENT_MIX_PROPERTIES));
    public static final DeferredHolder<Fluid, VirulentMixFluid.Flowing> VIRULENT_MIX_FLOWING = FLUIDS.register("virulent_mix_flowing", () -> new VirulentMixFluid.Flowing(VIRULENT_MIX_PROPERTIES));
    public static final BaseFlowingFluid.Properties VIRULENT_MIX_PROPERTIES = new BaseFlowingFluid.Properties(VIRULENT_MIX_TYPE, VIRULENT_MIX_SOURCE, VIRULENT_MIX_FLOWING).bucket(UGItems.VIRULENT_MIX_BUCKET).block(UGBlocks.VIRULENT_MIX);
}

