/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGTags;
import quek.undergarden.world.gen.structure.BiggerJigsawStructure;
import quek.undergarden.world.gen.structure.processor.NoWaterloggingProcessor;

public class UGStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"undergarden");
    public static final DeferredHolder<StructureType<?>, StructureType<BiggerJigsawStructure>> BIGGER_JIGSAW = STRUCTURES.register("bigger_jigsaw", () -> () -> BiggerJigsawStructure.CODEC);
    public static final ResourceKey<Structure> CATACOMBS = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)new ResourceLocation("undergarden", "catacombs"));
    public static final ResourceKey<StructureSet> CATACOMBS_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)new ResourceLocation("undergarden", "catacombs"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_START = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/catacombs_entrance"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_CHEST = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/chest_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_INTERIOR = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/interior_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_TUNNEL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/tunnel_pool"));
    public static final ResourceKey<StructureTemplatePool> CATACOMBS_WAY = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("undergarden", "catacombs/way_pool"));
    public static final ResourceKey<StructureProcessorList> CATACOMBS_DEGRADATION = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)new ResourceLocation("undergarden", "catacombs_degradation"));
    public static final ResourceKey<Structure> FORGOTTEN_VESTIGE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige"));
    public static final ResourceKey<StructureSet> FORGOTTEN_VESTIGE_SET = ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige"));
    public static final ResourceKey<StructureTemplatePool> FORGOTTEN_VESTIGE_POOL = ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige"));
    public static final ResourceKey<StructureProcessorList> FORGOTTEN_VESTIGE_DEGRADATION = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)new ResourceLocation("undergarden", "forgotten_vestige_degradation"));

    public static void bootstrapStructures(BootstapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(CATACOMBS, (Object)new BiggerJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(UGTags.Biomes.HAS_CATACOMBS), Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.FORGOTTEN.get(), 1, 1, 1)}))), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(CATACOMBS_START), Optional.empty(), 25, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)48)), Optional.empty(), 116, List.of()));
        context.register(FORGOTTEN_VESTIGE, (Object)new BiggerJigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(UGTags.Biomes.HAS_FORGOTTEN_VESTIGE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), (Holder<StructureTemplatePool>)pools.getOrThrow(FORGOTTEN_VESTIGE_POOL), Optional.empty(), 5, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.TOP), Optional.empty(), 10, List.of()));
    }

    public static void bootstrapSets(BootstapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(CATACOMBS_SET, (Object)new StructureSet((Holder)structures.getOrThrow(CATACOMBS), (StructurePlacement)new RandomSpreadStructurePlacement(24, 12, RandomSpreadType.LINEAR, 276320045)));
        context.register(FORGOTTEN_VESTIGE_SET, (Object)new StructureSet((Holder)structures.getOrThrow(FORGOTTEN_VESTIGE), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.ZERO, StructurePlacement.FrequencyReductionMethod.DEFAULT, 0.85f, 276320046, Optional.empty(), 6, 3, RandomSpreadType.LINEAR)));
    }

    public static void bootstrapPools(BootstapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        context.register(CATACOMBS_START, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/entrance").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_CHEST, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"minecraft:empty"), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/chest").toString()), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/chest_forgotten").toString()), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_INTERIOR, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/interior1").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/interior2").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/interior3").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/interior4").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100)), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_TUNNEL, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/way_pool").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel1").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel2").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel3").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel4").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel5").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel6").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel7").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/room1").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/room2").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/room3").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/tunnel_guardian").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)25), (Object[])new Pair[0]), StructureTemplatePool.Projection.RIGID));
        context.register(CATACOMBS_WAY, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/entrance").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/4way").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)25), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/3way").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)50), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/2way").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)75), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "catacombs/1way").toString(), (Holder)processors.getOrThrow(CATACOMBS_DEGRADATION)), (Object)100)), StructureTemplatePool.Projection.RIGID));
        context.register(FORGOTTEN_VESTIGE_POOL, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_1").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_2").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_3").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_4").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_5").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/arch_6").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/face_1").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/face_2").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/face_3").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_1").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_2").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_3").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), (Object[])new Pair[]{Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_4").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_5").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/depthrock/house_6").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_1").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_2").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_3").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_4").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_5").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1), Pair.of((Object)StructurePoolElement.single((String)new ResourceLocation("undergarden", "forgotten_vestige/shiverstone/arch_6").toString(), (Holder)processors.getOrThrow(FORGOTTEN_VESTIGE_DEGRADATION)), (Object)1)}), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapProcessors(BootstapContext<StructureProcessorList> context) {
        context.register(CATACOMBS_DEGRADATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.DEPTHROCK_BRICKS.get(), 0.5f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get()).defaultBlockState()))), new NoWaterloggingProcessor())));
        context.register(FORGOTTEN_VESTIGE_DEGRADATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.DEPTHROCK_BRICKS.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.CRACKED_DEPTHROCK_BRICKS.get()).defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.SHIVERSTONE_BRICKS.get(), 0.25f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.CRACKED_SHIVERSTONE_BRICKS.get()).defaultBlockState()), new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)UGBlocks.CLOGGRUM_BLOCK.get(), 0.5f), (RuleTest)AlwaysTrueTest.INSTANCE, ((Block)UGBlocks.RAW_CLOGGRUM_BLOCK.get()).defaultBlockState()))))));
    }
}

