/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import quek.undergarden.registry.UGItems;

public class UGTrimMaterials {
    public static final ResourceKey<TrimMaterial> CLOGGRUM = UGTrimMaterials.registerKey("cloggrum");
    public static final ResourceKey<TrimMaterial> FROSTSTEEL = UGTrimMaterials.registerKey("froststeel");
    public static final ResourceKey<TrimMaterial> UTHERIUM = UGTrimMaterials.registerKey("utherium");
    public static final ResourceKey<TrimMaterial> REGALIUM = UGTrimMaterials.registerKey("regalium");
    public static final ResourceKey<TrimMaterial> FORGOTTEN = UGTrimMaterials.registerKey("forgotten");

    private static ResourceKey<TrimMaterial> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)new ResourceLocation("undergarden", name));
    }

    public static void bootstrap(BootstapContext<TrimMaterial> context) {
        UGTrimMaterials.register(context, CLOGGRUM, UGItems.CLOGGRUM_INGOT, Style.EMPTY.withColor(9863528), 0.2f);
        UGTrimMaterials.register(context, FROSTSTEEL, UGItems.FROSTSTEEL_INGOT, Style.EMPTY.withColor(9484768), 0.9f);
        UGTrimMaterials.register(context, UTHERIUM, UGItems.UTHERIUM_CRYSTAL, Style.EMPTY.withColor(14440522), 0.4f);
        UGTrimMaterials.register(context, REGALIUM, UGItems.REGALIUM_CRYSTAL, Style.EMPTY.withColor(16570493), 0.6f);
        UGTrimMaterials.register(context, FORGOTTEN, UGItems.FORGOTTEN_INGOT, Style.EMPTY.withColor(4769934), 0.7f);
    }

    private static void register(BootstapContext<TrimMaterial> context, ResourceKey<TrimMaterial> trimKey, Holder<Item> trimItem, Style color, float itemModelIndex) {
        TrimMaterial material = new TrimMaterial(trimKey.location().getPath(), trimItem, itemModelIndex, Map.of(), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)trimKey.location())).withStyle(color));
        context.register(trimKey, (Object)material);
    }
}

