/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world;

import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.ITeleporter;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.block.UndergardenPortalBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGPointOfInterests;

public class UGTeleporter
implements ITeleporter {
    protected final ServerLevel level;
    private final BlockState frame = !BuiltInRegistries.BLOCK.containsKey(ResourceLocation.tryParse((String)((String)UndergardenConfig.Common.return_portal_frame_block_id.get()))) ? Blocks.STONE_BRICKS.defaultBlockState() : ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)((String)UndergardenConfig.Common.return_portal_frame_block_id.get())))).defaultBlockState();

    public UGTeleporter(ServerLevel level) {
        this.level = level;
    }

    public Optional<BlockUtil.FoundRectangle> getExistingPortal(BlockPos pos) {
        PoiManager poiManager = this.level.getPoiManager();
        poiManager.ensureLoadedAndValid((LevelReader)this.level, pos, 64);
        Optional<PoiRecord> optional = poiManager.getInSquare(poiType -> poiType.is(UGPointOfInterests.UNDERGARDEN_PORTAL.getKey()), pos, 64, PoiManager.Occupancy.ANY).sorted(Comparator.comparingDouble(poi -> poi.getPos().distSqr((Vec3i)pos)).thenComparingInt(poi -> poi.getPos().getY())).filter(poi -> this.level.getBlockState(poi.getPos()).hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)).findFirst();
        return optional.map(poi -> {
            BlockPos blockpos = poi.getPos();
            this.level.getChunkSource().addRegionTicket(TicketType.PORTAL, new ChunkPos(blockpos), 3, (Object)blockpos);
            BlockState blockstate = this.level.getBlockState(blockpos);
            return BlockUtil.getLargestRectangleAround((BlockPos)blockpos, (Direction.Axis)((Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)), (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> this.level.getBlockState(blockPos) == blockstate);
        });
    }

    public Optional<BlockUtil.FoundRectangle> makePortal(BlockPos pos, Direction.Axis axis) {
        Direction direction = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        double d0 = -1.0;
        BlockPos blockpos = null;
        double d1 = -1.0;
        BlockPos blockpos1 = null;
        WorldBorder worldborder = this.level.getWorldBorder();
        int i = Math.min(this.level.getMaxBuildHeight(), this.level.getMinBuildHeight() + this.level.getLogicalHeight()) - 1;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        for (BlockPos.MutableBlockPos checkPos : BlockPos.spiralAround((BlockPos)pos, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int validStartHeight = Math.min(i, this.level.getHeight(Heightmap.Types.MOTION_BLOCKING, checkPos.getX(), checkPos.getZ()));
            if (!worldborder.isWithinBounds((BlockPos)checkPos) || !worldborder.isWithinBounds((BlockPos)checkPos.move(direction, 1))) continue;
            checkPos.move(direction.getOpposite(), 1);
            for (int l = validStartHeight; l >= this.level.getMinBuildHeight(); --l) {
                int j1;
                checkPos.setY(l);
                if (!this.canPortalReplaceBlock(checkPos)) continue;
                int i1 = l;
                while (l > this.level.getMinBuildHeight() && this.canPortalReplaceBlock(checkPos.move(Direction.DOWN))) {
                    --l;
                }
                if (l + 4 > i || (j1 = i1 - l) > 0 && j1 < 3) continue;
                checkPos.setY(l);
                if (!this.canHostFrame((BlockPos)checkPos, blockpos$mutableblockpos, direction, 0)) continue;
                double d2 = pos.distSqr((Vec3i)checkPos);
                if (this.canHostFrame((BlockPos)checkPos, blockpos$mutableblockpos, direction, -1) && this.canHostFrame((BlockPos)checkPos, blockpos$mutableblockpos, direction, 1) && (d0 == -1.0 || d0 > d2)) {
                    d0 = d2;
                    blockpos = checkPos.immutable();
                }
                if (d0 != -1.0 || d1 != -1.0 && !(d1 > d2)) continue;
                d1 = d2;
                blockpos1 = checkPos.immutable();
            }
        }
        if (d0 == -1.0 && d1 != -1.0) {
            blockpos = blockpos1;
            d0 = d1;
        }
        if (d0 == -1.0) {
            int i2 = i - 9;
            int k1 = Math.max(this.level.getMinBuildHeight() + 1, 70);
            if (i2 < k1) {
                return Optional.empty();
            }
            blockpos = new BlockPos(pos.getX(), Mth.clamp((int)pos.getY(), (int)k1, (int)i2), pos.getZ()).immutable();
            Direction direction1 = direction.getClockWise();
            if (!worldborder.isWithinBounds(blockpos)) {
                return Optional.empty();
            }
            for (int i3 = -1; i3 < 2; ++i3) {
                for (int j3 = 0; j3 < 2; ++j3) {
                    for (int k3 = -1; k3 < 3; ++k3) {
                        BlockState blockstate1 = k3 < 0 ? this.frame : Blocks.AIR.defaultBlockState();
                        blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, j3 * direction.getStepX() + i3 * direction1.getStepX(), k3, j3 * direction.getStepZ() + i3 * direction1.getStepZ());
                        this.level.setBlockAndUpdate((BlockPos)blockpos$mutableblockpos, blockstate1);
                    }
                }
            }
        }
        for (int l1 = -1; l1 < 3; ++l1) {
            for (int j2 = -1; j2 < 4; ++j2) {
                if (l1 != -1 && l1 != 2 && j2 != -1 && j2 != 3) continue;
                blockpos$mutableblockpos.setWithOffset(blockpos, l1 * direction.getStepX(), j2, l1 * direction.getStepZ());
                this.level.setBlock((BlockPos)blockpos$mutableblockpos, this.frame, 3);
            }
        }
        BlockState blockstate = (BlockState)((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).defaultBlockState().setValue(UndergardenPortalBlock.AXIS, (Comparable)axis);
        for (int k2 = 0; k2 < 2; ++k2) {
            for (int l2 = 0; l2 < 3; ++l2) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos, k2 * direction.getStepX(), l2, k2 * direction.getStepZ());
                this.level.setBlock((BlockPos)blockpos$mutableblockpos, blockstate, 18);
            }
        }
        return Optional.of(new BlockUtil.FoundRectangle(blockpos.immutable(), 2, 3));
    }

    private boolean canPortalReplaceBlock(BlockPos.MutableBlockPos pos) {
        BlockState blockstate = this.level.getBlockState((BlockPos)pos);
        return blockstate.canBeReplaced() && blockstate.getFluidState().isEmpty();
    }

    private boolean canHostFrame(BlockPos originalPos, BlockPos.MutableBlockPos offsetPos, Direction direction, int offsetScale) {
        Direction checkDir = direction.getClockWise();
        for (int i = -1; i < 3; ++i) {
            for (int j = -1; j < 4; ++j) {
                offsetPos.setWithOffset((Vec3i)originalPos, direction.getStepX() * i + checkDir.getStepX() * offsetScale, j, direction.getStepZ() * i + checkDir.getStepZ() * offsetScale);
                if (j < 0 && !this.level.getBlockState((BlockPos)offsetPos).isSolid()) {
                    return false;
                }
                if (j < 0 || this.canPortalReplaceBlock(offsetPos)) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public PortalInfo getPortalInfo(Entity entity, ServerLevel level, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        boolean destinationIsUG;
        boolean bl = destinationIsUG = level.dimension() == UGDimensions.UNDERGARDEN_LEVEL;
        if (entity.level().dimension() != UGDimensions.UNDERGARDEN_LEVEL && !destinationIsUG) {
            return null;
        }
        WorldBorder border = level.getWorldBorder();
        double coordinateDifference = DimensionType.getTeleportationScale((DimensionType)entity.level().dimensionType(), (DimensionType)level.dimensionType());
        BlockPos pos = border.clampToBounds(entity.getX() * coordinateDifference, entity.getY(), entity.getZ() * coordinateDifference);
        return this.getOrMakePortal(entity, pos).map(result -> {
            Vec3 vector3d;
            Direction.Axis axis;
            BlockState blockstate = entity.level().getBlockState(entity.portalEntrancePos);
            if (blockstate.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                axis = (Direction.Axis)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                BlockUtil.FoundRectangle rectangle = BlockUtil.getLargestRectangleAround((BlockPos)entity.portalEntrancePos, (Direction.Axis)axis, (int)21, (Direction.Axis)Direction.Axis.Y, (int)21, blockPos -> entity.level().getBlockState(blockPos) == blockstate);
                vector3d = PortalShape.getRelativePosition((BlockUtil.FoundRectangle)rectangle, (Direction.Axis)axis, (Vec3)entity.position(), (EntityDimensions)entity.getDimensions(entity.getPose()));
            } else {
                axis = Direction.Axis.X;
                vector3d = new Vec3(0.5, 0.0, 0.0);
            }
            return PortalShape.createPortalInfo((ServerLevel)level, (BlockUtil.FoundRectangle)result, (Direction.Axis)axis, (Vec3)vector3d, (Entity)entity, (Vec3)entity.getDeltaMovement(), (float)entity.getYRot(), (float)entity.getXRot());
        }).orElse(null);
    }

    protected Optional<BlockUtil.FoundRectangle> getOrMakePortal(Entity entity, BlockPos pos) {
        Optional<BlockUtil.FoundRectangle> existingPortal = this.getExistingPortal(pos);
        if (existingPortal.isPresent()) {
            return existingPortal;
        }
        Direction.Axis portalAxis = this.level.getBlockState(entity.portalEntrancePos).getOptionalValue(UndergardenPortalBlock.AXIS).orElse(Direction.Axis.X);
        return this.makePortal(pos, portalAxis);
    }

    public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
        return false;
    }
}

