/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;
import quek.undergarden.block.fluid.VirulentMixFluid;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGFluids;

public class UGCaveWorldCarver
extends CaveWorldCarver {
    public UGCaveWorldCarver(Codec<CaveCarverConfiguration> configCodec) {
        super(configCodec);
        this.liquids = ImmutableSet.of((Object)Fluids.WATER);
    }

    protected float getThickness(RandomSource random) {
        return super.getThickness(random) * 3.0f;
    }

    protected boolean carveEllipsoid(CarvingContext context, CaveCarverConfiguration config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomeAccessor, Aquifer aquifer, double x, double y, double z, double horizontalRadius, double verticalRadius, CarvingMask carvingMask, WorldCarver.CarveSkipChecker skipChecker) {
        ChunkPos chunkPos = chunk.getPos();
        double middleX = chunkPos.getMiddleBlockX();
        double middleZ = chunkPos.getMiddleBlockZ();
        double d2 = 16.0 + horizontalRadius * 2.0;
        if (!(Math.abs(x - middleX) > d2) && !(Math.abs(z - middleZ) > d2)) {
            int i2;
            int l1;
            int minX = chunkPos.getMinBlockX();
            int minZ = chunkPos.getMinBlockZ();
            int k = Math.max(Mth.floor((double)(x - horizontalRadius)) - minX - 1, 0);
            int l = Math.min(Mth.floor((double)(x + horizontalRadius)) - minX, 15);
            int i1 = Math.max(Mth.floor((double)(y - verticalRadius)) - 1, context.getMinGenY() + 1);
            int j1 = chunk.isUpgrading() ? 0 : 7;
            int k1 = Math.min(Mth.floor((double)(y + verticalRadius)) + 1, context.getMinGenY() + context.getGenDepth() - 1 - j1);
            if (this.hasDisallowedLiquid(chunk, k, l, i1, k1, l1 = Math.max(Mth.floor((double)(z - horizontalRadius)) - minZ - 1, 0), i2 = Math.min(Mth.floor((double)(z + horizontalRadius)) - minZ, 15))) {
                return false;
            }
            boolean flag = false;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (int j2 = k; j2 <= l; ++j2) {
                int k2 = chunkPos.getBlockX(j2);
                double d3 = ((double)k2 + 0.5 - x) / horizontalRadius;
                for (int l2 = l1; l2 <= i2; ++l2) {
                    int i3 = chunkPos.getBlockZ(l2);
                    double d4 = ((double)i3 + 0.5 - z) / horizontalRadius;
                    if (d3 * d3 + d4 * d4 >= 1.0) continue;
                    MutableBoolean mutableboolean = new MutableBoolean(false);
                    for (int j3 = k1; j3 > i1; --j3) {
                        double d5 = ((double)j3 - 0.5 - y) / verticalRadius;
                        if (skipChecker.shouldSkip(context, d3, d5, d4, j3) || carvingMask.get(j2, j3, l2)) continue;
                        carvingMask.set(j2, j3, l2);
                        blockpos$mutableblockpos.set(k2, j3, i3);
                        flag |= this.carveBlock(context, config, chunk, biomeAccessor, carvingMask, blockpos$mutableblockpos, blockpos$mutableblockpos1, aquifer, mutableboolean);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    protected boolean carveBlock(CarvingContext context, CaveCarverConfiguration config, ChunkAccess chunk, Function<BlockPos, Holder<Biome>> biomeAccessor, CarvingMask carvingMask, BlockPos.MutableBlockPos pos, BlockPos.MutableBlockPos checkPos, Aquifer aquifer, MutableBoolean reachedSurface) {
        BlockState chunkState = chunk.getBlockState((BlockPos)pos);
        if (chunkState.is((Block)UGBlocks.DEEPTURF_BLOCK.get()) || chunkState.is((Block)UGBlocks.FROZEN_DEEPTURF_BLOCK.get()) || chunkState.is((Block)UGBlocks.ASHEN_DEEPTURF_BLOCK.get())) {
            reachedSurface.setTrue();
        }
        if (!this.canReplaceBlock((CarverConfiguration)config, chunkState)) {
            return false;
        }
        BlockState carveState = this.getCarveState(context, config, (BlockPos)pos);
        if (carveState == null) {
            return false;
        }
        chunk.setBlockState((BlockPos)pos, carveState, false);
        if (aquifer.shouldScheduleFluidUpdate() && !carveState.getFluidState().isEmpty()) {
            chunk.markPosForPostprocessing((BlockPos)pos);
        }
        if (reachedSurface.isTrue()) {
            checkPos.setWithOffset((Vec3i)pos, Direction.DOWN);
            if (chunk.getBlockState((BlockPos)checkPos).is((Block)UGBlocks.DEEPSOIL.get())) {
                context.topMaterial(biomeAccessor, chunk, (BlockPos)checkPos, !carveState.getFluidState().isEmpty()).ifPresent(state -> {
                    chunk.setBlockState((BlockPos)checkPos, state, false);
                    if (!state.getFluidState().isEmpty()) {
                        chunk.markPosForPostprocessing((BlockPos)checkPos);
                    }
                });
            }
        }
        return true;
    }

    private BlockState getCarveState(CarvingContext context, CaveCarverConfiguration config, BlockPos pos) {
        if (pos.getY() <= config.lavaLevel.resolveY((WorldGenerationContext)context)) {
            return ((VirulentMixFluid.Source)((Object)UGFluids.VIRULENT_MIX_SOURCE.get())).defaultFluidState().createLegacyBlock();
        }
        return CAVE_AIR;
    }

    protected boolean hasDisallowedLiquid(ChunkAccess chunk, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        ChunkPos chunkpos = chunk.getPos();
        int minBlockX = chunkpos.getMinBlockX();
        int minBlockZ = chunkpos.getMinBlockZ();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY - 1; y <= maxY + 1; ++y) {
                    mutablePos.set(minBlockX + x, y, minBlockZ + z);
                    if (this.liquids.contains(chunk.getFluidState((BlockPos)mutablePos).getType())) {
                        return true;
                    }
                    if (y == maxY + 1 || UGCaveWorldCarver.isEdge(x, z, minX, maxX, minZ, maxZ)) continue;
                    y = maxY;
                }
            }
        }
        return false;
    }

    private static boolean isEdge(int x, int z, int minX, int maxX, int minZ, int maxZ) {
        return x == minX || x == maxX || z == minZ || z == maxZ;
    }
}

