/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.foliageplacer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import quek.undergarden.block.MushroomVeilBlock;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGFoliagePlacers;

public class VeilFoliagePlacer
extends FoliagePlacer {
    public static final Codec<VeilFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> VeilFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, VeilFoliagePlacer::new));

    public VeilFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)UGFoliagePlacers.VEIL.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int height, int radius, int offset) {
        VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)attachment.pos());
        this.circle(-1, radius - 2, false, level, blockSetter, random, config, attachment.pos());
        this.circle(-2, radius - 2, false, level, blockSetter, random, config, attachment.pos());
        this.circle(-3, radius - 1, false, level, blockSetter, random, config, attachment.pos());
        this.circle(-4, radius, true, level, blockSetter, random, config, attachment.pos());
    }

    private void circle(int centerY, int radius, boolean veil, LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, BlockPos pos) {
        int d = (5 - radius * 4) / 4;
        int x = 0;
        int z = radius;
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        do {
            posMutable.setWithOffset((Vec3i)pos, x + 1, centerY, z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.setWithOffset((Vec3i)pos, x, centerY, z - 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.SOUTH, VineBlock.EAST, level, blockSetter, random);
                } else {
                    this.addHangingVeil(posMutable, VineBlock.SOUTH, level, blockSetter, random);
                }
            }
            posMutable.setWithOffset((Vec3i)pos, x, centerY, z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.setWithOffset((Vec3i)pos, x + 1, centerY, -z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.setWithOffset((Vec3i)pos, x, centerY, -z + 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.NORTH, VineBlock.EAST, level, blockSetter, random);
                } else {
                    this.addHangingVeil(posMutable, VineBlock.NORTH, level, blockSetter, random);
                }
            }
            posMutable.setWithOffset((Vec3i)pos, x, centerY, -z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.setWithOffset((Vec3i)pos, -x - 1, centerY, z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.setWithOffset((Vec3i)pos, -x, centerY, z - 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.SOUTH, VineBlock.WEST, level, blockSetter, random);
                }
            }
            posMutable.setWithOffset((Vec3i)pos, -x, centerY, z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.setWithOffset((Vec3i)pos, -x - 1, centerY, -z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.setWithOffset((Vec3i)pos, -x, centerY, -z + 1);
                if (x == 1 || x == 2) {
                    this.addHangingVeil(posMutable, VineBlock.NORTH, VineBlock.WEST, level, blockSetter, random);
                }
            }
            posMutable.setWithOffset((Vec3i)pos, -x, centerY, -z);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.setWithOffset((Vec3i)pos, z, centerY, x);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.setWithOffset((Vec3i)pos, z - 1, centerY, x);
                if (x == 0) {
                    this.addHangingVeil(posMutable, VineBlock.EAST, level, blockSetter, random);
                }
            }
            posMutable.setWithOffset((Vec3i)pos, z, centerY, -x);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            posMutable.setWithOffset((Vec3i)pos, -z, centerY, x);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (veil) {
                posMutable.setWithOffset((Vec3i)pos, -z + 1, centerY, x);
                if (x == 0) {
                    this.addHangingVeil(posMutable, VineBlock.WEST, level, blockSetter, random);
                }
            }
            posMutable.setWithOffset((Vec3i)pos, -z, centerY, -x);
            VeilFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)posMutable);
            if (d < 0) {
                d += 2 * x + 1;
                continue;
            }
            d += 2 * (x - z) + 1;
            --z;
        } while (++x <= z);
    }

    private void addHangingVeil(BlockPos.MutableBlockPos posMutable, BooleanProperty side, LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random) {
        int length = 4 - random.nextInt(3);
        blockSetter.set((BlockPos)posMutable, (BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true))).setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(true)));
        for (int i = 0; i <= length; ++i) {
            if (level.isStateAtPosition((BlockPos)posMutable, BlockBehaviour.BlockStateBase::isAir)) {
                if (i == length || !level.isStateAtPosition(posMutable.below(), BlockBehaviour.BlockStateBase::isAir)) {
                    blockSetter.set((BlockPos)posMutable, (BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true))).setValue((Property)MushroomVeilBlock.END, (Comparable)Boolean.valueOf(true)));
                    break;
                }
                blockSetter.set((BlockPos)posMutable, (BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true)));
            }
            posMutable.move(Direction.DOWN);
        }
    }

    private void addHangingVeil(BlockPos.MutableBlockPos posMutable, BooleanProperty side, BooleanProperty side2, LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random) {
        int length = 4 - random.nextInt(3);
        blockSetter.set((BlockPos)posMutable, (BlockState)((BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true))).setValue((Property)side2, (Comparable)Boolean.valueOf(true))).setValue((Property)VineBlock.UP, (Comparable)Boolean.valueOf(true)));
        for (int i = 0; i <= length; ++i) {
            if (level.isStateAtPosition((BlockPos)posMutable, BlockBehaviour.BlockStateBase::isAir)) {
                if (i == length || !level.isStateAtPosition(posMutable.below(), BlockBehaviour.BlockStateBase::isAir)) {
                    blockSetter.set((BlockPos)posMutable, (BlockState)((BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true))).setValue((Property)side2, (Comparable)Boolean.valueOf(true))).setValue((Property)MushroomVeilBlock.END, (Comparable)Boolean.valueOf(true)));
                    break;
                }
                blockSetter.set((BlockPos)posMutable, (BlockState)((BlockState)((Block)UGBlocks.MUSHROOM_VEIL.get()).defaultBlockState().setValue((Property)side, (Comparable)Boolean.valueOf(true))).setValue((Property)side2, (Comparable)Boolean.valueOf(true)));
            }
            posMutable.move(Direction.DOWN);
        }
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }
}

