/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.treedecorator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import quek.undergarden.registry.UGTreeDecoratorTypes;

public class ReplaceLeafDecorator
extends TreeDecorator {
    public static final Codec<ReplaceLeafDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)BlockStateProvider.CODEC.fieldOf("block").forGetter(decorator -> decorator.blockProvider)).apply((Applicative)instance, ReplaceLeafDecorator::new));
    private final float probability;
    protected final BlockStateProvider blockProvider;

    public ReplaceLeafDecorator(float probability, BlockStateProvider blockProvider) {
        this.probability = probability;
        this.blockProvider = blockProvider;
    }

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)UGTreeDecoratorTypes.REPLACE_LEAF_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        context.leaves().forEach(pos -> {
            if (random.nextFloat() < this.probability) {
                context.setBlock(pos, this.blockProvider.getState(random, pos));
            }
        });
    }
}

