/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.trunkplacer;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import quek.undergarden.registry.UGTrunkPlacerTypes;

public class SingleForkingTrunkPlacer
extends TrunkPlacer {
    public static final Codec<SingleForkingTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SingleForkingTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, SingleForkingTrunkPlacer::new));

    public SingleForkingTrunkPlacer(int baseHeight, int heightRandomA, int heightRandomB) {
        super(baseHeight, heightRandomA, heightRandomB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)UGTrunkPlacerTypes.SINGLE_FORKING_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        SingleForkingTrunkPlacer.setDirtAt((LevelSimulatedReader)level, blockSetter, (RandomSource)random, (BlockPos)pos.below(), (TreeConfiguration)config);
        ArrayList list = Lists.newArrayList();
        Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        int i = freeTreeHeight - random.nextInt(4) - 1;
        int j = 3 - random.nextInt(3);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        int x = pos.getX();
        int y = pos.getZ();
        OptionalInt optionalInt = OptionalInt.empty();
        for (int i1 = 0; i1 < freeTreeHeight; ++i1) {
            int j1 = pos.getY() + i1;
            if (i1 >= i && j > 0) {
                x += direction.getStepX();
                y += direction.getStepZ();
                --j;
            }
            if (!this.placeLog(level, blockSetter, random, (BlockPos)mutablePos.set(x, j1, y), config)) continue;
            optionalInt = OptionalInt.of(j1 + 1);
        }
        if (optionalInt.isPresent()) {
            list.add(new FoliagePlacer.FoliageAttachment(new BlockPos(x, optionalInt.getAsInt(), y), 1, false));
        }
        return list;
    }
}

