/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.trunkplacer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import quek.undergarden.registry.UGTrunkPlacerTypes;

public class SmogstemTrunkPlacer
extends TrunkPlacer {
    protected final int width;
    public static final Codec<SmogstemTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("base_height").forGetter(placer -> placer.baseHeight), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(placer -> placer.heightRandA), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(placer -> placer.heightRandB), (App)Codec.intRange((int)1, (int)2).fieldOf("width").forGetter(placer -> placer.width)).apply((Applicative)instance, SmogstemTrunkPlacer::new));

    public SmogstemTrunkPlacer(int baseHeight, int firstRandHeight, int secondRandHeight, int width) {
        super(baseHeight, firstRandHeight, secondRandHeight);
        this.width = width;
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)UGTrunkPlacerTypes.SMOGSTEM_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> blockSetter, RandomSource random, int freeTreeHeight, BlockPos pos, TreeConfiguration config) {
        BlockGetter blockGetter = (BlockGetter)level;
        int treeBaseHeight = config.trunkPlacer.getTreeHeight(random);
        int width = this.width;
        for (int y = 0; y < treeBaseHeight; ++y) {
            float thiccness = (1.0f - (float)y / (float)treeBaseHeight) * (float)width;
            int l = Mth.ceil((float)treeBaseHeight);
            for (int i1 = -l; i1 <= l; ++i1) {
                float f1 = (float)Mth.abs((int)i1) - 0.25f;
                for (int j1 = -l; j1 <= l; ++j1) {
                    float f2 = (float)Mth.abs((int)j1) - 0.25f;
                    if ((i1 != 0 || j1 != 0) && f1 * f1 + f2 * f2 > thiccness * thiccness || (i1 == -l || i1 == l || j1 == -l || j1 == l) && random.nextFloat() > 0.75f) continue;
                    BlockState blockstate = blockGetter.getBlockState(pos.offset(i1, y, j1));
                    if (blockstate.isAir()) {
                        this.placeLog(level, blockSetter, random, pos.offset(i1, y, j1), config);
                    }
                    if (y == 0 || l <= 1 || !(blockstate = blockGetter.getBlockState(pos.offset(i1, -y, j1))).isAir()) continue;
                    this.placeLog(level, blockSetter, random, pos.offset(i1, y, j1), config);
                }
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(pos.above(treeBaseHeight), 0, false));
    }
}

