/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.promoter.api;

import com.google.gson.Gson;
import dev.ftb.mods.promoter.api.PromoData;
import dev.ftb.mods.promoter.api.PromoResponse;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoFetcher.class);
    private static final InfoFetcher INSTANCE = new InfoFetcher();
    private static final String API_URL = "https://api.feed-the-beast.com/v1/meta/promotions";
    private final List<PromoData> promotions = Collections.synchronizedList(new ArrayList());

    private InfoFetcher() {
    }

    public static InfoFetcher get() {
        return INSTANCE;
    }

    public void load() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL)).GET().build();
            ((CompletableFuture)((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(data -> {
                try {
                    Gson gson = new Gson();
                    PromoResponse response = (PromoResponse)gson.fromJson(data, PromoResponse.class);
                    this.promotions.addAll(response.promotions());
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse response", (Throwable)e);
                }
            })).exceptionally(e -> {
                LOGGER.error("Failed to fetch promotions", e);
                return null;
            });
        }
        catch (Exception e2) {
            LOGGER.error("Failed to fetch promotions", (Throwable)e2);
        }
    }

    public List<PromoData> getPromotions() {
        return this.promotions;
    }
}

