/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import yalter.mousetweaks.Config;
import yalter.mousetweaks.IGuiScreenHandler;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.MouseButton;
import yalter.mousetweaks.WheelSearchOrder;
import yalter.mousetweaks.api.IMTModGuiContainer3Ex;
import yalter.mousetweaks.handlers.GuiContainerCreativeHandler;
import yalter.mousetweaks.handlers.GuiContainerHandler;
import yalter.mousetweaks.handlers.IMTModGuiContainer3ExHandler;

public class Main {
    public static Config config;
    private static Minecraft mc;
    private static Screen openScreen;
    private static IGuiScreenHandler handler;
    private static boolean disableWheelForThisContainer;
    private static Slot oldSelectedSlot;
    private static double accumulatedScrollDelta;
    private static boolean canDoLMBDrag;
    private static boolean canDoRMBDrag;
    private static boolean rmbTweakLeftOriginalSlot;
    private static boolean initialized;

    public static void initialize() {
        Logger.Log("Main.initialize()");
        if (initialized) {
            return;
        }
        mc = Minecraft.getInstance();
        config = new Config(Main.mc.gameDirectory.getAbsolutePath() + File.separator + "config" + File.separator + "MouseTweaks.cfg");
        config.read();
        Logger.Log("Initialized.");
        initialized = true;
    }

    private static void updateScreen(Screen newScreen) {
        if (newScreen == openScreen) {
            return;
        }
        openScreen = newScreen;
        handler = null;
        oldSelectedSlot = null;
        accumulatedScrollDelta = 0.0;
        canDoLMBDrag = false;
        canDoRMBDrag = false;
        rmbTweakLeftOriginalSlot = false;
        if (openScreen != null) {
            Logger.DebugLog("You have just opened a " + openScreen.getClass().getName() + ".");
            config.read();
            handler = Main.findHandler(openScreen);
            if (handler == null) {
                Logger.DebugLog("No valid handler found; Mouse Tweaks is disabled.");
            } else {
                boolean disableForThisContainer = handler.isMouseTweaksDisabled();
                disableWheelForThisContainer = handler.isWheelTweakDisabled();
                Logger.DebugLog("Handler: " + handler.getClass().getSimpleName() + "; Mouse Tweaks is " + (disableForThisContainer ? "disabled" : "enabled") + "; wheel tweak is " + (disableWheelForThisContainer ? "disabled" : "enabled") + ".");
                if (disableForThisContainer) {
                    handler = null;
                }
            }
        }
    }

    public static boolean onMouseClicked(Screen screen, double x, double y, MouseButton button) {
        Main.updateScreen(screen);
        if (handler == null) {
            return false;
        }
        oldSelectedSlot = handler.getSlotUnderMouse(x, y);
        ItemStack stackOnMouse = Main.mc.player.containerMenu.getCarried();
        if (button == MouseButton.LEFT) {
            if (stackOnMouse.isEmpty()) {
                canDoLMBDrag = true;
            }
        } else if (button == MouseButton.RIGHT) {
            if (stackOnMouse.isEmpty()) {
                return false;
            }
            if (!Main.config.rmbTweak) {
                return false;
            }
            canDoRMBDrag = true;
            rmbTweakLeftOriginalSlot = false;
        }
        return false;
    }

    private static void rmbTweakMaybeClickSlot(Slot slot, ItemStack stackOnMouse) {
        if (slot == null) {
            return;
        }
        if (stackOnMouse.isEmpty()) {
            return;
        }
        if (handler.isIgnored(slot)) {
            return;
        }
        if (handler.isCraftingOutput(slot)) {
            return;
        }
        if (!(stackOnMouse.getItem() instanceof BundleItem)) {
            ItemStack selectedSlotStack = slot.getItem();
            if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                return;
            }
            if (selectedSlotStack.getCount() == slot.getMaxStackSize(selectedSlotStack)) {
                return;
            }
        }
        handler.clickSlot(slot, MouseButton.RIGHT, false);
    }

    public static boolean onMouseReleased(Screen screen, double x, double y, MouseButton button) {
        Main.updateScreen(screen);
        if (handler == null) {
            return false;
        }
        if (button == MouseButton.LEFT) {
            canDoLMBDrag = false;
        } else if (button == MouseButton.RIGHT) {
            canDoRMBDrag = false;
        }
        return false;
    }

    public static boolean onMouseDrag(Screen screen, double x, double y, MouseButton button) {
        Main.updateScreen(screen);
        if (handler == null) {
            return false;
        }
        Slot selectedSlot = handler.getSlotUnderMouse(x, y);
        if (selectedSlot == oldSelectedSlot) {
            return false;
        }
        ItemStack stackOnMouse = Main.mc.player.containerMenu.getCarried();
        if (canDoRMBDrag && button == MouseButton.RIGHT && !rmbTweakLeftOriginalSlot) {
            rmbTweakLeftOriginalSlot = true;
            handler.disableRMBDraggingFunctionality();
            Main.rmbTweakMaybeClickSlot(oldSelectedSlot, stackOnMouse);
        }
        oldSelectedSlot = selectedSlot;
        if (selectedSlot == null) {
            return false;
        }
        if (handler.isIgnored(selectedSlot)) {
            return false;
        }
        if (button == MouseButton.LEFT) {
            boolean shiftIsDown;
            if (!canDoLMBDrag) {
                return false;
            }
            ItemStack selectedSlotStack = selectedSlot.getItem();
            if (selectedSlotStack.isEmpty()) {
                return false;
            }
            boolean bl = shiftIsDown = InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)340) || InputConstants.isKeyDown((long)mc.getWindow().getWindow(), (int)344);
            if (stackOnMouse.isEmpty()) {
                if (!Main.config.lmbTweakWithoutItem || !shiftIsDown) {
                    return false;
                }
                handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
            } else {
                if (!Main.config.lmbTweakWithItem) {
                    return false;
                }
                if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                    return false;
                }
                if (shiftIsDown) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, true);
                } else {
                    if (stackOnMouse.getCount() + selectedSlotStack.getCount() > stackOnMouse.getMaxStackSize()) {
                        return false;
                    }
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    if (!handler.isCraftingOutput(selectedSlot)) {
                        handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    }
                }
            }
        } else if (button == MouseButton.RIGHT) {
            if (!canDoRMBDrag) {
                return false;
            }
            Main.rmbTweakMaybeClickSlot(selectedSlot, stackOnMouse);
        }
        return false;
    }

    public static boolean onMouseScrolled(Screen screen, double x, double y, double scrollDelta) {
        Slot targetSlot;
        ItemStack selectedSlotStack;
        boolean pushItems;
        Main.updateScreen(screen);
        if (handler == null || disableWheelForThisContainer || !Main.config.wheelTweak) {
            return false;
        }
        Slot selectedSlot = handler.getSlotUnderMouse(x, y);
        if (selectedSlot == null || handler.isIgnored(selectedSlot)) {
            return false;
        }
        double scaledDelta = Main.config.scrollItemScaling.scale(scrollDelta);
        if (accumulatedScrollDelta != 0.0 && Math.signum(scaledDelta) != Math.signum(accumulatedScrollDelta)) {
            accumulatedScrollDelta = 0.0;
        }
        int delta = (int)(accumulatedScrollDelta += scaledDelta);
        accumulatedScrollDelta -= (double)delta;
        if (delta == 0) {
            return true;
        }
        List<Slot> slots = handler.getSlots();
        int numItemsToMove = Math.abs(delta);
        boolean bl = pushItems = delta < 0;
        if (Main.config.wheelScrollDirection.isPositionAware() && Main.otherInventoryIsAbove(selectedSlot, slots)) {
            boolean bl2 = pushItems = !pushItems;
        }
        if (Main.config.wheelScrollDirection.isInverted()) {
            boolean bl3 = pushItems = !pushItems;
        }
        if ((selectedSlotStack = selectedSlot.getItem()).isEmpty()) {
            return true;
        }
        ItemStack stackOnMouse = Main.mc.player.containerMenu.getCarried();
        if (handler.isCraftingOutput(selectedSlot)) {
            if (!Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
                return true;
            }
            if (stackOnMouse.isEmpty()) {
                List<Slot> targetSlots;
                if (!pushItems) {
                    return true;
                }
                while (numItemsToMove-- > 0 && (targetSlots = Main.findPushSlots(slots, selectedSlot, selectedSlotStack.getCount(), true)) != null) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                    for (int i = 0; i < targetSlots.size(); ++i) {
                        Slot slot = targetSlots.get(i);
                        if (i == targetSlots.size() - 1) {
                            handler.clickSlot(slot, MouseButton.LEFT, false);
                            continue;
                        }
                        int clickTimes = slot.getMaxStackSize(slot.getItem()) - slot.getItem().getCount();
                        while (clickTimes-- > 0) {
                            handler.clickSlot(slot, MouseButton.RIGHT, false);
                        }
                    }
                }
            } else {
                while (numItemsToMove-- > 0) {
                    handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                }
            }
            return true;
        }
        if (!stackOnMouse.isEmpty() && Main.areStacksCompatible(selectedSlotStack, stackOnMouse)) {
            return true;
        }
        if (pushItems) {
            if (!stackOnMouse.isEmpty() && !selectedSlot.mayPlace(stackOnMouse)) {
                return true;
            }
            numItemsToMove = Math.min(numItemsToMove, selectedSlotStack.getCount());
            List<Slot> targetSlots = Main.findPushSlots(slots, selectedSlot, numItemsToMove, false);
            assert (targetSlots != null);
            if (targetSlots.isEmpty()) {
                return true;
            }
            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            for (Slot slot : targetSlots) {
                int clickTimes = slot.getMaxStackSize(slot.getItem()) - slot.getItem().getCount();
                clickTimes = Math.min(clickTimes, numItemsToMove);
                numItemsToMove -= clickTimes;
                while (clickTimes-- > 0) {
                    handler.clickSlot(slot, MouseButton.RIGHT, false);
                }
            }
            handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            return true;
        }
        int maxItemsToMove = selectedSlot.getMaxStackSize(selectedSlotStack) - selectedSlotStack.getCount();
        numItemsToMove = Math.min(numItemsToMove, maxItemsToMove);
        while (numItemsToMove > 0 && (targetSlot = Main.findPullSlot(slots, selectedSlot)) != null) {
            int numItemsInTargetSlot = targetSlot.getItem().getCount();
            if (handler.isCraftingOutput(targetSlot)) {
                if (maxItemsToMove < numItemsInTargetSlot) break;
                numItemsToMove = Math.min(numItemsToMove - 1, maxItemsToMove -= numItemsInTargetSlot);
                if (!stackOnMouse.isEmpty() && !selectedSlot.mayPlace(stackOnMouse)) break;
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                handler.clickSlot(targetSlot, MouseButton.LEFT, false);
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
                continue;
            }
            int numItemsToMoveFromTargetSlot = Math.min(numItemsToMove, numItemsInTargetSlot);
            maxItemsToMove -= numItemsToMoveFromTargetSlot;
            numItemsToMove -= numItemsToMoveFromTargetSlot;
            if (!stackOnMouse.isEmpty() && !targetSlot.mayPlace(stackOnMouse)) break;
            handler.clickSlot(targetSlot, MouseButton.LEFT, false);
            if (numItemsToMoveFromTargetSlot == numItemsInTargetSlot) {
                handler.clickSlot(selectedSlot, MouseButton.LEFT, false);
            } else {
                for (int i = 0; i < numItemsToMoveFromTargetSlot; ++i) {
                    handler.clickSlot(selectedSlot, MouseButton.RIGHT, false);
                }
            }
            handler.clickSlot(targetSlot, MouseButton.LEFT, false);
        }
        return true;
    }

    private static boolean otherInventoryIsAbove(Slot selectedSlot, List<Slot> slots) {
        boolean selectedIsInPlayerInventory = selectedSlot.container == Main.mc.player.getInventory();
        int otherInventorySlotsBelow = 0;
        int otherInventorySlotsAbove = 0;
        for (Slot slot : slots) {
            if (slot.container == Main.mc.player.getInventory() == selectedIsInPlayerInventory) continue;
            if (slot.y < selectedSlot.y) {
                ++otherInventorySlotsAbove;
                continue;
            }
            ++otherInventorySlotsBelow;
        }
        return otherInventorySlotsAbove > otherInventorySlotsBelow;
    }

    private static IGuiScreenHandler findHandler(Screen currentScreen) {
        if (currentScreen instanceof IMTModGuiContainer3Ex) {
            return new IMTModGuiContainer3ExHandler((IMTModGuiContainer3Ex)currentScreen);
        }
        if (currentScreen instanceof CreativeModeInventoryScreen) {
            return new GuiContainerCreativeHandler((CreativeModeInventoryScreen)currentScreen);
        }
        if (currentScreen instanceof AbstractContainerScreen) {
            return new GuiContainerHandler((AbstractContainerScreen)currentScreen);
        }
        return null;
    }

    private static boolean areStacksCompatible(ItemStack a, ItemStack b) {
        return a.isEmpty() || b.isEmpty() || ItemStack.isSameItem((ItemStack)a, (ItemStack)b) && ItemStack.isSameItemSameTags((ItemStack)a, (ItemStack)b);
    }

    private static Slot findPullSlot(List<Slot> slots, Slot selectedSlot) {
        int direction;
        int endIndex;
        if (Main.config.wheelSearchOrder == WheelSearchOrder.FIRST_TO_LAST) {
            startIndex = 0;
            endIndex = slots.size();
            direction = 1;
        } else {
            startIndex = slots.size() - 1;
            endIndex = -1;
            direction = -1;
        }
        ItemStack selectedSlotStack = selectedSlot.getItem();
        boolean findInPlayerInventory = selectedSlot.container != Main.mc.player.getInventory();
        for (int i = startIndex; i != endIndex; i += direction) {
            ItemStack stack;
            boolean slotInPlayerInventory;
            Slot slot = slots.get(i);
            if (handler.isIgnored(slot)) continue;
            boolean bl = slotInPlayerInventory = slot.container == Main.mc.player.getInventory();
            if (findInPlayerInventory != slotInPlayerInventory || (stack = slot.getItem()).isEmpty() || !Main.areStacksCompatible(selectedSlotStack, stack)) continue;
            return slot;
        }
        return null;
    }

    private static List<Slot> findPushSlots(List<Slot> slots, Slot selectedSlot, int itemCount, boolean mustDistributeAll) {
        Slot slot;
        int i;
        ItemStack selectedSlotStack = selectedSlot.getItem();
        boolean findInPlayerInventory = selectedSlot.container != Main.mc.player.getInventory();
        ArrayList<Slot> rv = new ArrayList<Slot>();
        ArrayList<Slot> goodEmptySlots = new ArrayList<Slot>();
        for (i = 0; i != slots.size() && itemCount > 0; ++i) {
            boolean slotInPlayerInventory;
            slot = slots.get(i);
            if (handler.isIgnored(slot)) continue;
            boolean bl = slotInPlayerInventory = slot.container == Main.mc.player.getInventory();
            if (findInPlayerInventory != slotInPlayerInventory || handler.isCraftingOutput(slot)) continue;
            ItemStack stack = slot.getItem();
            if (stack.isEmpty()) {
                if (!slot.mayPlace(selectedSlotStack)) continue;
                goodEmptySlots.add(slot);
                continue;
            }
            if (!Main.areStacksCompatible(selectedSlotStack, stack) || stack.getCount() >= slot.getMaxStackSize(stack)) continue;
            rv.add(slot);
            itemCount -= Math.min(itemCount, slot.getMaxStackSize(stack) - stack.getCount());
        }
        for (i = 0; i != goodEmptySlots.size() && itemCount > 0; itemCount -= Math.min(itemCount, slot.getMaxStackSize()), ++i) {
            slot = (Slot)goodEmptySlots.get(i);
            rv.add(slot);
        }
        if (mustDistributeAll && itemCount > 0) {
            return null;
        }
        return rv;
    }

    static {
        openScreen = null;
        handler = null;
        disableWheelForThisContainer = false;
        oldSelectedSlot = null;
        accumulatedScrollDelta = 0.0;
        canDoLMBDrag = false;
        canDoRMBDrag = false;
        rmbTweakLeftOriginalSlot = false;
        initialized = false;
    }
}

