/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.integratedcrafting.inventory.container.ContainerPartInterfaceCraftingSettings;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.client.gui.container.ContainerScreenPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;

public class ContainerScreenPartInterfaceCraftingSettings
extends ContainerScreenPartSettings<ContainerPartInterfaceCraftingSettings>
implements IInputListener {
    private WidgetArrowedListField<IngredientComponent<?, ?>> ingredientComponentSideSelector = null;
    private WidgetTextFieldDropdown<Direction> dropdownFieldSide = null;
    private List<ContainerScreenPartSettings.SideDropdownEntry> dropdownEntries;
    private IngredientComponent<?, ?> selectedIngredientComponent = null;
    private WidgetNumberField numberFieldChannelInterfaceCrafting = null;
    private ButtonCheckbox checkboxFieldDisabledCraftingCheck = null;
    private ButtonCheckbox checkboxFieldBlockingMode = null;

    public ContainerScreenPartInterfaceCraftingSettings(ContainerPartInterfaceCraftingSettings container, Inventory inventory, Component title) {
        super((ContainerPartSettings)container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedcrafting", "textures/gui/part_interface_settings.png");
    }

    protected boolean isFieldSideEnabled() {
        return false;
    }

    protected int getFieldSideY() {
        return 34;
    }

    protected int getFieldUpdateIntervalY() {
        return 59;
    }

    protected int getFieldPriorityY() {
        return 84;
    }

    protected int getFieldChannelY() {
        return 109;
    }

    protected void onSave() {
        super.onSave();
        try {
            Direction selectedSide = this.dropdownFieldSide.getSelectedDropdownPossibility() == null ? null : (Direction)this.dropdownFieldSide.getSelectedDropdownPossibility().getValue();
            int side = selectedSide != null && selectedSide != this.getDefaultSide() ? selectedSide.ordinal() : -1;
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartInterfaceCraftingSettings)this.getMenu()).getTargetSideOverrideValueId(this.selectedIngredientComponent), (int)side);
            int channelInterface = this.numberFieldChannelInterfaceCrafting.getInt();
            ValueNotifierHelpers.setValue((IValueNotifier)((IValueNotifier)this.getMenu()), (int)((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastChannelInterfaceCraftingValueId(), (int)channelInterface);
            ((ContainerPartInterfaceCraftingSettings)this.getMenu()).setLastDisableCraftingCheckValue(this.checkboxFieldDisabledCraftingCheck.isChecked());
            ((ContainerPartInterfaceCraftingSettings)this.getMenu()).setLastBlockingModeValue(this.checkboxFieldBlockingMode.isChecked());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void init() {
        super.init();
        this.ingredientComponentSideSelector = new WidgetArrowedListField<IngredientComponent<?, ?>>(this.font, this.leftPos + 106, this.topPos + 9, 68, 15, true, (Component)Component.translatable((String)"gui.integratedcrafting.partsettings.ingredient"), true, Lists.newArrayList((Iterable)IngredientComponent.REGISTRY)){

            protected String activeElementToString(IngredientComponent<?, ?> element) {
                return L10NHelpers.localize((String)element.getTranslationKey(), (Object[])new Object[0]);
            }
        };
        this.ingredientComponentSideSelector.setListener((IInputListener)this);
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.dropdownEntries = Arrays.stream(Direction.values()).map(x$0 -> new ContainerScreenPartSettings.SideDropdownEntry((ContainerScreenPartSettings)this, x$0)).collect(Collectors.toList());
        this.dropdownFieldSide = new WidgetTextFieldDropdown(this.font, this.leftPos + 106, this.topPos + 34, 68, 14, (Component)Component.translatable((String)"gui.integrateddynamics.partsettings.side"), true, (Set)Sets.newHashSet(this.dropdownEntries));
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.container).getTargetSideOverrideValue(this.selectedIngredientComponent));
        this.dropdownFieldSide.setMaxLength(15);
        this.dropdownFieldSide.setVisible(true);
        this.dropdownFieldSide.setTextColor(0xFFFFFF);
        this.dropdownFieldSide.setCanLoseFocus(true);
        this.numberFieldChannelInterfaceCrafting = new WidgetNumberField(this.font, this.leftPos + 106, this.topPos + 134, 70, 14, true, (Component)Component.translatable((String)"gui.integratedcrafting.partsettings.channel.interface"), true);
        this.numberFieldChannelInterfaceCrafting.setPositiveOnly(false);
        this.numberFieldChannelInterfaceCrafting.setMaxLength(15);
        this.numberFieldChannelInterfaceCrafting.setVisible(true);
        this.numberFieldChannelInterfaceCrafting.setTextColor(0xFFFFFF);
        this.numberFieldChannelInterfaceCrafting.setCanLoseFocus(true);
        this.checkboxFieldDisabledCraftingCheck = new ButtonCheckbox(this.leftPos + 110, this.topPos + 149, 110, 10, (Component)Component.translatable((String)"gui.integratedcrafting.partsettings.craftingcheckdisabled"), entry -> {});
        this.checkboxFieldBlockingMode = new ButtonCheckbox(this.leftPos + 110, this.topPos + 159, 110, 10, (Component)Component.translatable((String)"gui.integratedcrafting.partsettings.blockingmode"), entry -> {});
        this.refreshValues();
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.numberFieldChannelInterfaceCrafting.charTyped(typedChar, keyCode) && !this.dropdownFieldSide.charTyped(typedChar, keyCode)) {
            return super.charTyped(typedChar, keyCode);
        }
        return true;
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256) {
            if (this.numberFieldChannelInterfaceCrafting.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
            if (this.dropdownFieldSide.keyPressed(typedChar, keyCode, modifiers)) {
                return true;
            }
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.ingredientComponentSideSelector.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.dropdownFieldSide.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.numberFieldChannelInterfaceCrafting.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.checkboxFieldDisabledCraftingCheck.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.checkboxFieldBlockingMode.mouseClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.font.drawInBatch(L10NHelpers.localize((String)"gui.integrateddynamics.partsettings.side", (Object[])new Object[0]), (float)(this.leftPos + 8), (float)(this.topPos + 12), Helpers.RGBToInt((int)0, (int)0, (int)0), false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.ingredientComponentSideSelector.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.dropdownFieldSide.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.font.drawInBatch(L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.channel.interface", (Object[])new Object[0]), (float)(this.leftPos + 8), (float)(this.topPos + 137), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.numberFieldChannelInterfaceCrafting.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.font.drawInBatch(L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.craftingcheckdisabled", (Object[])new Object[0]), (float)(this.leftPos + 8), (float)(this.topPos + 152), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.checkboxFieldDisabledCraftingCheck.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.font.drawInBatch(L10NHelpers.localize((String)"gui.integratedcrafting.partsettings.blockingmode", (Object[])new Object[0]), (float)(this.leftPos + 8), (float)(this.topPos + 162), 0, false, guiGraphics.pose().last().pose(), (MultiBufferSource)guiGraphics.bufferSource(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.checkboxFieldBlockingMode.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    protected int getBaseYSize() {
        return 256;
    }

    protected void setSideInDropdownField(IngredientComponent<?, ?> ingredientComponent, Direction side) {
        if (this.selectedIngredientComponent == ingredientComponent) {
            this.dropdownFieldSide.selectPossibility((IDropdownEntry)this.dropdownEntries.get(side.ordinal()));
        }
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        for (IngredientComponent ingredientComponent : IngredientComponent.REGISTRY.stream().toList()) {
            if (valueId != ((ContainerPartInterfaceCraftingSettings)this.getMenu()).getTargetSideOverrideValueId(ingredientComponent)) continue;
            int side = ((ContainerPartInterfaceCraftingSettings)this.getMenu()).getTargetSideOverrideValue(ingredientComponent).ordinal();
            this.setSideInDropdownField(ingredientComponent, side == -1 ? this.getDefaultSide() : Direction.values()[side]);
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastChannelInterfaceCraftingValueId()) {
            this.numberFieldChannelInterfaceCrafting.setValue(Integer.toString(((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastChannelInterfaceValue()));
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastDisableCraftingCheckValueId()) {
            this.checkboxFieldDisabledCraftingCheck.setChecked(((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastDisableCraftingCheckValue());
        }
        if (valueId == ((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastBlockingModeValueId()) {
            this.checkboxFieldBlockingMode.setChecked(((ContainerPartInterfaceCraftingSettings)this.getMenu()).getLastBlockingModeValue());
        }
    }

    public void onChanged() {
        this.onSave();
        this.selectedIngredientComponent = (IngredientComponent)this.ingredientComponentSideSelector.getActiveElement();
        this.setSideInDropdownField(this.selectedIngredientComponent, ((ContainerPartInterfaceCraftingSettings)this.getMenu()).getTargetSideOverrideValue(this.selectedIngredientComponent));
    }
}

