/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigLibClient;
import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="supermartijn642configlib")
public class ConfigLib {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"configlib");
    private static final List<ModConfig<?>> CONFIGS = new ArrayList();
    private static final Set<String> CONFIG_NAMES = new HashSet<String>();
    private static final List<ModConfig<?>> SYNCABLE_CONFIGS = new ArrayList();
    private static final Map<String, ModConfig<?>> SYNCABLE_CONFIGS_BY_IDENTIFIER = new HashMap();

    public ConfigLib(IEventBus eventBus) {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(ConfigLib::getModVersion, (remoteVersion, isFromServer) -> ConfigLib.canConnectWith(remoteVersion)));
        NeoForge.EVENT_BUS.addListener(e -> ConfigLib.onLoadGame());
        NeoForge.EVENT_BUS.addListener(e -> {
            if (e.getEntity() instanceof ServerPlayer) {
                ConfigLib.onPlayerJoinServer((ServerPlayer)e.getEntity());
            }
        });
        if (ConfigLib.isClientEnvironment()) {
            ConfigLibClient.registerEventListeners();
        }
        eventBus.addListener(e -> e.registrar("supermartijn642configlib").versioned(ConfigLib.getModVersion()).optional().configuration(new ResourceLocation("supermartijn642configlib", "sync_packet"), ConfigLib::handleSyncConfigPacket, (p, c) -> {}));
    }

    public static boolean isClientEnvironment() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isServerEnvironment() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("supermartijn642configlib").orElseThrow()).getModInfo().getVersion().toString();
    }

    public static boolean canConnectWith(String remoteVersion) {
        return SYNCABLE_CONFIGS.isEmpty() || ConfigLib.getModVersion().equals(remoteVersion);
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    protected static synchronized void addConfig(ModConfig<?> config) {
        if (CONFIG_NAMES.contains(config.getIdentifier())) {
            throw new IllegalStateException("Config '" + config.getIdentifier() + "' for mod '" + config.getModid() + "' already exists!");
        }
        CONFIGS.add(config);
        CONFIG_NAMES.add(config.getIdentifier());
        if (config.hasSyncableEntries()) {
            SYNCABLE_CONFIGS.add(config);
            SYNCABLE_CONFIGS_BY_IDENTIFIER.put(config.getIdentifier(), config);
        }
        config.initialize();
    }

    protected static void onLoadGame() {
        CONFIGS.forEach(ModConfig::onJoinGame);
    }

    protected static void onLeaveGame() {
        CONFIGS.forEach(ModConfig::onLeaveGame);
    }

    protected static void onPlayerJoinServer(ServerPlayer sender) {
        ConfigLib.sendSyncConfigPackets(sender);
    }

    private static void sendSyncConfigPackets(ServerPlayer sender) {
        for (ModConfig<?> config : SYNCABLE_CONFIGS) {
            PacketDistributor.PLAYER.with((Object)sender).send(new CustomPacketPayload[]{new ConfigSyncPacket(config)});
        }
    }

    protected static void writeSyncedEntriesPacket(ConfigSyncPacket packet, FriendlyByteBuf buffer) {
        ModConfig<?> config = packet.config;
        buffer.writeUtf(config.getIdentifier());
        try {
            config.writeSyncableEntries((ByteBuf)buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", e);
        }
    }

    protected static ConfigSyncPacket handleSyncConfigPacket(FriendlyByteBuf buffer) {
        String identifier = buffer.readUtf();
        ModConfig<?> config = SYNCABLE_CONFIGS_BY_IDENTIFIER.get(identifier);
        if (config == null) {
            LOGGER.error("Received config sync packet for unknown config '" + identifier + "'!");
            return null;
        }
        try {
            config.readSyncableValues((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
        }
        return new ConfigSyncPacket();
    }
}

