/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import pro.mikey.justhammers.HammerItems;
import pro.mikey.justhammers.HammerTags;

public class HammerItem
extends PickaxeItem {
    private final int depth;
    private final int radius;
    private TagKey<Block> blocks = BlockTags.MINEABLE_WITH_PICKAXE;

    public HammerItem(Tier tier, int radius, int depth, int level) {
        super(tier, 1, -2.8f, HammerItems.DEFAULT_PROPERTIES.durability(HammerItem.computeDurability(tier, level)));
        this.depth = depth;
        this.radius = radius;
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        list.add((Component)Component.translatable((String)"justhammers.tooltip.size", (Object[])new Object[]{this.radius, this.radius, this.depth}).withStyle(ChatFormatting.GRAY));
        int damage = itemStack.getDamageValue();
        int maxDamage = itemStack.getMaxDamage();
        int durabilityPercentage = (int)((float)(maxDamage - damage) / (float)maxDamage * 100.0f);
        ChatFormatting color = ChatFormatting.GREEN;
        if (durabilityPercentage <= 50) {
            color = durabilityPercentage <= 25 ? ChatFormatting.RED : ChatFormatting.YELLOW;
        }
        int remaining = durabilityPercentage / 20;
        MutableComponent percentComponent = Component.literal((String)(HammerItem.prettyDurability(damage) + "/" + HammerItem.prettyDurability(maxDamage) + " ")).append((Component)Component.literal((String)"*".repeat(remaining)).withStyle(color)).append((Component)Component.literal((String)"*".repeat(5 - remaining)).withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)(" (" + durabilityPercentage + "%)")).withStyle(ChatFormatting.GRAY));
        list.add((Component)percentComponent);
    }

    private static String prettyDurability(int durability) {
        String output;
        int unitIndex;
        String[] units = new String[]{"", "k", "m"};
        double displayDurability = durability;
        int n = unitIndex = durability > 0 ? (int)(Math.log10(durability) / 3.0) : 0;
        if (unitIndex >= units.length) {
            unitIndex = units.length - 1;
        }
        if ((output = String.format("%.2f", displayDurability /= Math.pow(1000.0, unitIndex))).endsWith(".00")) {
            output = output.substring(0, output.length() - 3);
        }
        return output + units[unitIndex];
    }

    private static int computeDurability(Tier tier, int level) {
        int baseModified = 0;
        if (level > 1) {
            baseModified = Tiers.NETHERITE.getUses();
        }
        return baseModified + ((int)((float)tier.getUses() * 2.5f) + 200 * level) * level;
    }

    public float getDestroySpeed(ItemStack itemStack, BlockState blockState) {
        if (itemStack.getMaxDamage() - itemStack.getDamageValue() <= 1) {
            return -1.0f;
        }
        return super.getDestroySpeed(itemStack, blockState);
    }

    public boolean isCorrectToolForDrops(BlockState blockState) {
        return this.actualIsCorrectToolForDrops(blockState);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.actualIsCorrectToolForDrops(state);
    }

    public boolean actualIsCorrectToolForDrops(BlockState state) {
        int i = this.getTier().getLevel();
        if (i < 3 && state.is(BlockTags.NEEDS_DIAMOND_TOOL)) {
            return false;
        }
        if (i < 2 && state.is(BlockTags.NEEDS_IRON_TOOL)) {
            return false;
        }
        return (i >= 1 || !state.is(BlockTags.NEEDS_STONE_TOOL)) && state.is(this.blocks);
    }

    public void causeAoe(Level level, BlockPos pos, BlockState state, ItemStack hammer, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (level.isClientSide || state.getDestroySpeed((BlockGetter)level, pos) == 0.0f) {
            return;
        }
        if (livingEntity.isCrouching()) {
            return;
        }
        HitResult pick = livingEntity.pick(20.0, 0.0f, false);
        if (!(pick instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)pick;
        this.findAndBreakNearBlocks(blockHitResult, pos, hammer, level, livingEntity);
        if ((double)hammer.getDamageValue() >= (double)hammer.getMaxDamage() * 0.95) {
            if (!hammer.getOrCreateTag().contains("has_been_warned")) {
                player.sendSystemMessage((Component)Component.translatable((String)"justhammers.tooltip.durability_warning").withStyle(ChatFormatting.RED), true);
                hammer.getOrCreateTag().putBoolean("has_been_warned", true);
            }
        } else if (hammer.getOrCreateTag().contains("has_been_warned")) {
            hammer.getOrCreateTag().remove("has_been_warned");
        }
    }

    public void findAndBreakNearBlocks(BlockHitResult pick, BlockPos blockPos, ItemStack hammerStack, Level level, LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Direction direction = pick.getDirection();
        BoundingBox boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, this.radius, this.depth);
        if (!player.isCreative() && hammerStack.getDamageValue() >= hammerStack.getMaxDamage() - 1) {
            return;
        }
        int damage = 0;
        Iterator iterator = BlockPos.betweenClosedStream((BoundingBox)boundingBox).iterator();
        HashSet<BlockPos> removedPos = new HashSet<BlockPos>();
        while (iterator.hasNext()) {
            boolean correctToolForDrops;
            EventResult eventResult;
            BlockPos pos = (BlockPos)iterator.next();
            if (!player.isCreative() && hammerStack.getDamageValue() + (damage + 1) >= hammerStack.getMaxDamage() - 1) break;
            BlockState targetState = level.getBlockState(pos);
            if (pos == blockPos || removedPos.contains(pos) || !this.canDestroy(targetState, level, pos) || !this.actualIsCorrectToolForDrops(targetState) || (eventResult = ((BlockEvent.Break)BlockEvent.BREAK.invoker()).breakBlock(level, pos, targetState, (ServerPlayer)livingEntity, null)).isFalse()) continue;
            removedPos.add(pos);
            level.destroyBlock(pos, false, (Entity)livingEntity);
            if (!player.isCreative() && (correctToolForDrops = hammerStack.isCorrectToolForDrops(targetState))) {
                targetState.spawnAfterBreak((ServerLevel)level, pos, hammerStack, true);
                List drops = Block.getDrops((BlockState)targetState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)livingEntity, (ItemStack)hammerStack);
                drops.forEach(e -> Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)pick.getDirection(), (ItemStack)e));
            }
            ++damage;
        }
        if (damage != 0 && !player.isCreative()) {
            hammerStack.hurtAndBreak(damage, livingEntity, livingEntityx -> livingEntityx.broadcastBreakEvent(EquipmentSlot.MAINHAND));
        }
    }

    public static BoundingBox getAreaOfEffect(BlockPos blockPos, Direction direction, int radius, int depth) {
        int size = radius / 2;
        int offset = size - 1;
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN, Direction.UP -> new BoundingBox(blockPos.getX() - size, blockPos.getY() - (direction == Direction.UP ? depth - 1 : 0), blockPos.getZ() - size, blockPos.getX() + size, blockPos.getY() + (direction == Direction.DOWN ? depth - 1 : 0), blockPos.getZ() + size);
            case Direction.NORTH, Direction.SOUTH -> new BoundingBox(blockPos.getX() - size, blockPos.getY() - size + offset, blockPos.getZ() - (direction == Direction.SOUTH ? depth - 1 : 0), blockPos.getX() + size, blockPos.getY() + size + offset, blockPos.getZ() + (direction == Direction.NORTH ? depth - 1 : 0));
            case Direction.WEST, Direction.EAST -> new BoundingBox(blockPos.getX() - (direction == Direction.EAST ? depth - 1 : 0), blockPos.getY() - size + offset, blockPos.getZ() - size, blockPos.getX() + (direction == Direction.WEST ? depth - 1 : 0), blockPos.getY() + size + offset, blockPos.getZ() + size);
        };
    }

    private boolean canDestroy(BlockState targetState, Level level, BlockPos pos) {
        if (targetState.getDestroySpeed((BlockGetter)level, pos) <= 0.0f) {
            return false;
        }
        if (targetState.is(HammerTags.HAMMER_NO_SMASHY)) {
            return false;
        }
        return level.getBlockEntity(pos) == null;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getRadius() {
        return this.radius;
    }
}

