/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.justhammers.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Iterator;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import pro.mikey.justhammers.HammerItem;
import pro.mikey.justhammers.HammerTags;

public class SelectionOutlineRender {
    public static void render(ClientLevel world, Camera camera, float v, PoseStack poseStack, MultiBufferSource consumers, GameRenderer gameRenderer, Matrix4f matrix4f, LightTexture lightTexture, LevelRenderer levelRenderer) {
        if (world == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (player.isCrouching()) {
            return;
        }
        ItemStack heldItem = player.getMainHandItem();
        ItemStack offHandItem = player.getOffhandItem();
        if (heldItem.isEmpty() && offHandItem.isEmpty()) {
            return;
        }
        if (!(heldItem.getItem() instanceof HammerItem) && !(offHandItem.getItem() instanceof HammerItem)) {
            return;
        }
        HitResult blockHitResult = Minecraft.getInstance().hitResult;
        if (blockHitResult == null || blockHitResult.getType() != HitResult.Type.BLOCK) {
            return;
        }
        Item item = heldItem.getItem() instanceof HammerItem ? heldItem.getItem() : offHandItem.getItem();
        HammerItem hammer = (HammerItem)item;
        BlockPos blockPos = ((BlockHitResult)blockHitResult).getBlockPos();
        Direction direction = ((BlockHitResult)blockHitResult).getDirection();
        BlockState block = world.getBlockState(blockPos);
        if (!hammer.actualIsCorrectToolForDrops(block) || block.is(HammerTags.HAMMER_NO_SMASHY)) {
            return;
        }
        BoundingBox boundingBox = HammerItem.getAreaOfEffect(blockPos, direction, hammer.getRadius(), hammer.getDepth());
        poseStack.pushPose();
        poseStack.translate(-camera.getPosition().x(), -camera.getPosition().y(), -camera.getPosition().z());
        Iterator blockPosStream = BlockPos.betweenClosedStream((BoundingBox)boundingBox).iterator();
        while (blockPosStream.hasNext()) {
            BlockPos pos = (BlockPos)blockPosStream.next();
            if (pos.equals((Object)blockPos) || world.getBlockState(pos).isAir()) continue;
            poseStack.pushPose();
            poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            LevelRenderer.renderShape((PoseStack)poseStack, (VertexConsumer)consumers.getBuffer(RenderType.lines()), (VoxelShape)Shapes.block(), (double)0.0, (double)0.0, (double)0.0, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.35f);
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

