/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.MITweaksOtherRegistries;
import net.swedz.mi_tweaks.MITweaksPackets;
import net.swedz.mi_tweaks.datagen.client.LanguageDatagenProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="mi_tweaks")
public final class MITweaks {
    public static final String ID = "mi_tweaks";
    public static final String NAME = "MI Tweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"MI Tweaks");

    public static ResourceLocation id(String path) {
        return new ResourceLocation(ID, path);
    }

    public MITweaks(IEventBus bus) {
        this.loadConfig();
        MITweaksItems.init(bus);
        MITweaksOtherRegistries.init(bus);
        bus.addListener(RegisterPayloadHandlerEvent.class, MITweaksPackets::init);
        bus.addListener(GatherDataEvent.class, event -> event.getGenerator().addProvider(event.includeClient(), (DataProvider)new LanguageDatagenProvider((GatherDataEvent)event)));
    }

    private void loadConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MITweaksConfig.SPEC);
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("%s-common.toml".formatted(ID))).preserveInsertionOrder().autoreload().writingMode(WritingMode.REPLACE).sync().build();
        configData.load();
        MITweaksConfig.SPEC.setConfig((CommentedConfig)configData);
        MITweaksConfig.loadConfig();
        LOGGER.info("Forcefully early-loaded config");
    }
}

