/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.swedz.mi_tweaks.MITweaks;
import net.swedz.mi_tweaks.MITweaksSortOrder;
import net.swedz.mi_tweaks.items.MachineBlueprintItem;
import net.swedz.tesseract.neoforge.registry.SortOrder;
import net.swedz.tesseract.neoforge.registry.common.CommonModelBuilders;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class MITweaksItems {
    public static final ItemHolder<MachineBlueprintItem> MACHINE_BLUEPRINT = ((ItemHolder)MITweaksItems.create("machine_blueprint", "Machine Blueprint", MachineBlueprintItem::new, MITweaksSortOrder.BLUEPRINTS).withModel(CommonModelBuilders::generated)).register();

    public static void init(IEventBus bus) {
        Registry.init(bus);
    }

    public static Set<ItemHolder> values() {
        return Set.copyOf(Registry.HOLDERS);
    }

    public static ItemHolder valueOf(String id) {
        return Registry.HOLDERS.stream().filter(holder -> holder.identifier().id().equals(id)).findFirst().orElseThrow();
    }

    public static <Type extends Item> ItemHolder<Type> create(String id, String englishName, Function<Item.Properties, Type> creator, SortOrder sortOrder) {
        ItemHolder holder = new ItemHolder(MITweaks.id(id), englishName, Registry.ITEMS, creator).sorted(sortOrder);
        Registry.include(holder);
        return holder;
    }

    public static final class Registry {
        public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"mi_tweaks");
        private static final Set<ItemHolder> HOLDERS = Sets.newHashSet();

        private static void init(IEventBus bus) {
            ITEMS.register(bus);
        }

        public static void include(ItemHolder holder) {
            HOLDERS.add(holder);
        }
    }
}

