/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks;

import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.swedz.mi_tweaks.MITweaksConfig;
import net.swedz.mi_tweaks.MITweaksItems;
import net.swedz.mi_tweaks.blueprint.BlueprintsLearned;
import net.swedz.mi_tweaks.blueprint.CopyBlueprintRecipe;
import net.swedz.mi_tweaks.items.MachineBlueprintItem;
import net.swedz.tesseract.neoforge.registry.holder.ItemHolder;

public final class MITweaksOtherRegistries {
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)"mi_tweaks");
    public static final DeferredHolder<RecipeSerializer<?>, SimpleCraftingRecipeSerializer<CopyBlueprintRecipe>> COPY_BLUEPRINT_SERIALIZER = RECIPE_SERIALIZERS.register("copy_blueprint", () -> new SimpleCraftingRecipeSerializer(CopyBlueprintRecipe::new));
    private static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"mi_tweaks");
    public static final Supplier<CreativeModeTab> CREATIVE_TAB = CREATIVE_MODE_TABS.register("mi_tweaks", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.%s.%s".formatted("mi_tweaks", "mi_tweaks"))).icon(() -> MITweaksItems.MACHINE_BLUEPRINT.asItem().getDefaultInstance()).displayItems((params, output) -> {
        Comparator<ItemHolder> compareBySortOrder = Comparator.comparing(ItemHolder::sortOrder);
        Comparator<ItemHolder> compareByName = Comparator.comparing(i -> i.identifier().id());
        MITweaksItems.values().stream().sorted(compareBySortOrder.thenComparing(compareByName)).forEach(item -> {
            output.accept((ItemLike)item);
            if (item.asItem() instanceof MachineBlueprintItem) {
                MITweaksConfig.machineBlueprintsMachines.stream().sorted(Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getKey(arg_0))).forEach(machineBlock -> {
                    ItemStack blueprintItem = MITweaksItems.MACHINE_BLUEPRINT.asItem().getDefaultInstance();
                    MachineBlueprintItem.setMachineBlock(blueprintItem, machineBlock);
                    output.accept(blueprintItem);
                });
            }
        });
    }).build());
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"mi_tweaks");
    public static final Supplier<AttachmentType<BlueprintsLearned>> BLUEPRINTS_LEARNED = ATTACHMENT_TYPES.register("blueprints_learned", () -> AttachmentType.serializable(BlueprintsLearned::new).copyOnDeath().build());

    public static void init(IEventBus bus) {
        RECIPE_SERIALIZERS.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        ATTACHMENT_TYPES.register(bus);
    }
}

