/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.guicomponent.waterpumpenvironment;

import aztech.modern_industrialization.machines.gui.ClientComponentRenderer;
import aztech.modern_industrialization.machines.gui.GuiComponentClient;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.util.RenderHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.guicomponent.waterpumpenvironment.WaterPumpEnvironmentGui;

public final class WaterPumpEnvironmentGuiClient
implements GuiComponentClient {
    private final WaterPumpEnvironmentGui.Parameters params;
    private boolean validEnvironment;

    public WaterPumpEnvironmentGuiClient(FriendlyByteBuf buf) {
        this.params = new WaterPumpEnvironmentGui.Parameters(buf.readInt(), buf.readInt());
        this.readCurrentData(buf);
    }

    public void readCurrentData(FriendlyByteBuf buf) {
        this.validEnvironment = buf.readBoolean();
    }

    public ClientComponentRenderer createRenderer(MachineScreen machineScreen) {
        return new Renderer();
    }

    private final class Renderer
    implements ClientComponentRenderer {
        private Renderer() {
        }

        public void renderBackground(GuiGraphics guiGraphics, int x, int y) {
            if (!WaterPumpEnvironmentGuiClient.this.validEnvironment) {
                int px = x + WaterPumpEnvironmentGuiClient.this.params.renderX();
                int py = y + WaterPumpEnvironmentGuiClient.this.params.renderY();
                guiGraphics.blit(MachineScreen.SLOT_ATLAS, px, py, 20, 58, 20, 20);
            }
        }

        public void renderTooltip(MachineScreen screen, Font font, GuiGraphics guiGraphics, int x, int y, int cursorX, int cursorY) {
            if (!WaterPumpEnvironmentGuiClient.this.validEnvironment && RenderHelper.isPointWithinRectangle((int)WaterPumpEnvironmentGuiClient.this.params.renderX(), (int)WaterPumpEnvironmentGuiClient.this.params.renderY(), (int)20, (int)20, (double)(cursorX - x), (double)(cursorY - y))) {
                List<FormattedCharSequence> lines = List.of(MITweaksText.WATER_PUMP_ENVIRONMENT_1.text().withStyle(ChatFormatting.RED).getVisualOrderText(), MITweaksText.WATER_PUMP_ENVIRONMENT_2.text().withStyle(ChatFormatting.RED).getVisualOrderText());
                guiGraphics.renderTooltip(font, lines, cursorX, cursorY);
            }
        }
    }
}

