/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machineprocesscondition;

import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.blockentities.multiblocks.ElectricBlastFurnaceBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.mixin.accessor.AbstractCraftingMultiblockBlockEntityAccessor;

public record EBFCoilProcessCondition(ElectricBlastFurnaceBlockEntity.Tier coilTier) implements MachineProcessCondition
{
    public static final Codec<EBFCoilProcessCondition> CODEC = RecordCodecBuilder.create(g -> g.group((App)StringRepresentable.fromValues(() -> ElectricBlastFurnaceBlockEntity.tiers.stream().map(WrappedEBFCoilTier::new).toList().toArray(new WrappedEBFCoilTier[0])).fieldOf("coil").forGetter(c -> new WrappedEBFCoilTier(c.coilTier()))).apply((Applicative)g, wrappedTier -> new EBFCoilProcessCondition(wrappedTier.coilTier())));

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        MachineBlockEntity machineBlockEntity = context.getBlockEntity();
        if (machineBlockEntity instanceof ElectricBlastFurnaceBlockEntity) {
            ElectricBlastFurnaceBlockEntity ebf = (ElectricBlastFurnaceBlockEntity)machineBlockEntity;
            AbstractCraftingMultiblockBlockEntityAccessor multiblock = (AbstractCraftingMultiblockBlockEntityAccessor)ebf;
            int activeShapeIndex = multiblock.getActiveShape().getActiveShapeIndex();
            ElectricBlastFurnaceBlockEntity.Tier ebfTier = (ElectricBlastFurnaceBlockEntity.Tier)ElectricBlastFurnaceBlockEntity.tiers.get(activeShapeIndex);
            return this.coilTier.maxBaseEu() <= ebfTier.maxBaseEu();
        }
        return false;
    }

    public void appendDescription(List<Component> list) {
        list.add((Component)MITweaksText.RECIPE_REQUIRES_COIL.text(this.coilTier.getDisplayName()));
    }

    public Codec<? extends MachineProcessCondition> codec(boolean syncToClient) {
        return CODEC;
    }

    private record WrappedEBFCoilTier(ElectricBlastFurnaceBlockEntity.Tier coilTier) implements StringRepresentable
    {
        public String getSerializedName() {
            return this.coilTier.coilBlockId().toString();
        }
    }
}

