/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.machineprocesscondition;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.recipe.MachineRecipe;
import aztech.modern_industrialization.machines.recipe.condition.MachineProcessCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.swedz.mi_tweaks.MITweaksText;
import net.swedz.mi_tweaks.api.CableTierHolder;

public record VoltageProcessCondition(CableTier tier) implements MachineProcessCondition
{
    public static final Codec<VoltageProcessCondition> CODEC = RecordCodecBuilder.create(g -> g.group((App)StringRepresentable.fromValues(() -> CableTier.allTiers().stream().map(WrappedCableTier::new).toList().toArray(new WrappedCableTier[0])).fieldOf("voltage").forGetter(c -> new WrappedCableTier(c.tier()))).apply((Applicative)g, wrappedTier -> new VoltageProcessCondition(wrappedTier.tier())));

    public boolean canProcessRecipe(MachineProcessCondition.Context context, MachineRecipe recipe) {
        MachineBlockEntity machineBlockEntity = context.getBlockEntity();
        if (machineBlockEntity instanceof CableTierHolder) {
            CableTierHolder machine = (CableTierHolder)machineBlockEntity;
            return machine.getCableTier().eu >= this.tier.eu;
        }
        return false;
    }

    public void appendDescription(List<Component> list) {
        list.add((Component)MITweaksText.RECIPE_REQUIRES_VOLTAGE.text(Component.translatable((String)this.tier.shortEnglishKey())));
    }

    public Codec<? extends MachineProcessCondition> codec(boolean syncToClient) {
        return CODEC;
    }

    private record WrappedCableTier(CableTier tier) implements StringRepresentable
    {
        public String getSerializedName() {
            return this.tier.name;
        }
    }
}

