/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.mi_tweaks.packets;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.swedz.mi_tweaks.MITweaksOtherRegistries;
import net.swedz.mi_tweaks.blueprint.BlueprintsLearned;
import net.swedz.mi_tweaks.packets.BasePacket;
import net.swedz.mi_tweaks.proxy.CommonProxy;

public record UpdateBlueprintsLearnedPacket(Set<ResourceLocation> machineIds) implements BasePacket
{
    public UpdateBlueprintsLearnedPacket(BlueprintsLearned blueprintsLearned) {
        this(blueprintsLearned.get());
    }

    public UpdateBlueprintsLearnedPacket(FriendlyByteBuf buf) {
        this(Sets.newHashSet());
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.machineIds.add(buf.readResourceLocation());
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.machineIds.size());
        for (ResourceLocation machineId : this.machineIds) {
            buf.writeResourceLocation(machineId);
        }
    }

    @Override
    public void handle() {
        if (CommonProxy.INSTANCE.isClient()) {
            Player player = CommonProxy.INSTANCE.getClientPlayer();
            BlueprintsLearned blueprintsLearned = (BlueprintsLearned)player.getData(MITweaksOtherRegistries.BLUEPRINTS_LEARNED);
            blueprintsLearned.mergeFrom(this.machineIds);
        }
    }
}

