/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class MultiItemStackHandler
implements IItemHandler {
    protected NonNullList<ItemStack> modifiable;
    protected NonNullList<ItemStack> takeOnly;
    @Nullable
    protected Predicate<ItemStack> inputValidator;

    public MultiItemStackHandler(NonNullList<ItemStack> modifiable, NonNullList<ItemStack> takeOnly, Predicate<ItemStack> inputValidator) {
        this.modifiable = modifiable;
        this.takeOnly = takeOnly;
        this.inputValidator = inputValidator;
    }

    public MultiItemStackHandler(NonNullList<ItemStack> modifiable, NonNullList<ItemStack> takeOnly) {
        this(modifiable, takeOnly, null);
    }

    public int getSlots() {
        return this.modifiable.size() + this.takeOnly.size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return (ItemStack)this.getList(slot).get(this.getListIndex(slot));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.getStackInSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.isEmpty()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.getCount();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.getCount() > limit;
        if (!simulate) {
            if (existing.isEmpty()) {
                this.getList(slot).set(this.getListIndex(slot), (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.grow(reachedLimit ? limit : stack.getCount());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.getCount() - limit)) : ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        this.validateSlotIndex(slot);
        if (!this.canExtract(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int toExtract = Math.min(amount, existing.getMaxStackSize());
        if (existing.getCount() <= toExtract) {
            if (!simulate) {
                this.getList(slot).set(this.getListIndex(slot), (Object)ItemStack.EMPTY);
                return existing;
            }
            return existing.copy();
        }
        if (!simulate) {
            this.getList(slot).set(this.getListIndex(slot), (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.getCount() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        if (slot < this.modifiable.size()) {
            if (this.inputValidator != null) {
                return this.inputValidator.test(stack);
            }
            return true;
        }
        return false;
    }

    protected boolean canExtract(int slot) {
        return slot >= this.modifiable.size();
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize());
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.getSlots()) {
            throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
        }
    }

    protected NonNullList<ItemStack> getList(int slot) {
        this.validateSlotIndex(slot);
        if (slot < this.modifiable.size()) {
            return this.modifiable;
        }
        return this.takeOnly;
    }

    protected int getListIndex(int slot) {
        this.validateSlotIndex(slot);
        if (slot < this.modifiable.size()) {
            return slot;
        }
        return slot - this.modifiable.size();
    }
}

