/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.blocks.tileentity;

import de.maxhenkel.easypiglins.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easypiglins.items.ModItems;
import de.maxhenkel.easypiglins.items.PiglinItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PiglinTileentity
extends FakeWorldTileentity {
    private ItemStack piglin = ItemStack.EMPTY;
    private Piglin piglinEntity;

    public PiglinTileentity(BlockEntityType<?> type, BlockState defaultState, BlockPos pos, BlockState state) {
        super(type, defaultState, pos, state);
    }

    public ItemStack getPiglin() {
        if (this.piglinEntity != null) {
            ((PiglinItem)((Object)ModItems.PIGLIN.get())).setPiglin(this.piglin, this.piglinEntity);
        }
        return this.piglin;
    }

    public boolean hasPiglin() {
        return !this.piglin.isEmpty();
    }

    public Piglin getPiglinEntity() {
        if (this.piglinEntity == null && !this.piglin.isEmpty()) {
            this.piglinEntity = ((PiglinItem)((Object)ModItems.PIGLIN.get())).getPiglin(this.level, this.piglin);
        }
        return this.piglinEntity;
    }

    public void setPiglin(ItemStack piglin) {
        this.piglin = piglin;
        if (piglin.isEmpty()) {
            this.piglinEntity = null;
        } else {
            this.piglinEntity = ((PiglinItem)((Object)ModItems.PIGLIN.get())).getPiglin(this.level, piglin);
            this.onAddPiglin(this.piglinEntity);
        }
        this.setChanged();
        this.sync();
    }

    protected void onAddPiglin(Piglin piglin) {
    }

    public ItemStack removePiglin() {
        ItemStack v = this.getPiglin();
        this.setPiglin(ItemStack.EMPTY);
        return v;
    }

    protected void saveAdditional(CompoundTag compound) {
        super.saveAdditional(compound);
        if (this.hasPiglin()) {
            CompoundTag comp = new CompoundTag();
            this.getPiglin().save(comp);
            compound.put("Piglin", (Tag)comp);
        }
    }

    public void load(CompoundTag compound) {
        if (compound.contains("Piglin")) {
            CompoundTag comp = compound.getCompound("Piglin");
            this.piglin = ItemStack.of((CompoundTag)comp);
            this.piglinEntity = null;
        } else {
            this.removePiglin();
        }
        super.load(compound);
    }
}

